/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.crypto.lms;

import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.apusic.org.bouncycastle.crypto.KeyGenerationParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMS;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSKeyGenerationParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import java.security.SecureRandom;

public class LMSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    LMSKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (LMSKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom source = this.param.getRandom();
        byte[] I = new byte[16];
        source.nextBytes(I);
        byte[] rootSecret = new byte[32];
        source.nextBytes(rootSecret);
        LMSPrivateKeyParameters privKey = LMS.generateKeys(this.param.getParameters().getLMSigParam(), this.param.getParameters().getLMOTSParam(), 0, I, rootSecret);
        return new AsymmetricCipherKeyPair(privKey.getPublicKey(), privKey);
    }
}

