/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.crypto.xmss;

import com.apusic.org.bouncycastle.crypto.CipherParameters;
import com.apusic.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.apusic.org.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.BDS;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.XMSSMTSignature;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.apusic.org.bouncycastle.pqc.crypto.xmss.XMSSVerifierUtil;
import com.apusic.org.bouncycastle.util.Arrays;

public class XMSSMTSigner
implements StateAwareMessageSigner {
    private XMSSMTPrivateKeyParameters privateKey;
    private XMSSMTPublicKeyParameters publicKey;
    private XMSSMTParameters params;
    private XMSSParameters xmssParams;
    private WOTSPlus wotsPlus;
    private boolean hasGenerated;
    private boolean initSign;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.initSign = true;
            this.hasGenerated = false;
            this.privateKey = (XMSSMTPrivateKeyParameters)param;
            this.params = this.privateKey.getParameters();
            this.xmssParams = this.params.getXMSSParameters();
        } else {
            this.initSign = false;
            this.publicKey = (XMSSMTPublicKeyParameters)param;
            this.params = this.publicKey.getParameters();
            this.xmssParams = this.params.getXMSSParameters();
        }
        this.wotsPlus = this.params.getWOTSPlus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateSignature(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (this.initSign) {
            if (this.privateKey == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.privateKey;
        synchronized (xMSSMTPrivateKeyParameters) {
            byte[] byArray;
            if (this.privateKey.getUsagesRemaining() <= 0L) {
                throw new IllegalStateException("no usages of private key remaining");
            }
            if (this.privateKey.getBDSState().isEmpty()) {
                throw new IllegalStateException("not initialized");
            }
            try {
                BDSStateMap bdsState = this.privateKey.getBDSState();
                long globalIndex = this.privateKey.getIndex();
                int totalHeight = this.params.getHeight();
                int xmssHeight = this.xmssParams.getHeight();
                if (this.privateKey.getUsagesRemaining() <= 0L) {
                    throw new IllegalStateException("index out of bounds");
                }
                byte[] random = this.wotsPlus.getKhf().PRF(this.privateKey.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(globalIndex, 32));
                byte[] concatenated = Arrays.concatenate(random, this.privateKey.getRoot(), XMSSUtil.toBytesBigEndian(globalIndex, this.params.getTreeDigestSize()));
                byte[] messageDigest = this.wotsPlus.getKhf().HMsg(concatenated, message);
                this.hasGenerated = true;
                XMSSMTSignature signature = new XMSSMTSignature.Builder(this.params).withIndex(globalIndex).withRandom(random).build();
                long indexTree = XMSSUtil.getTreeIndex(globalIndex, xmssHeight);
                int indexLeaf = XMSSUtil.getLeafIndex(globalIndex, xmssHeight);
                this.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], this.privateKey.getPublicSeed());
                OTSHashAddress otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
                if (bdsState.get(0) == null || indexLeaf == 0) {
                    bdsState.put(0, new BDS(this.xmssParams, this.privateKey.getPublicSeed(), this.privateKey.getSecretKeySeed(), otsHashAddress));
                }
                WOTSPlusSignature wotsPlusSignature = this.wotsSign(messageDigest, otsHashAddress);
                XMSSReducedSignature reducedSignature = new XMSSReducedSignature.Builder(this.xmssParams).withWOTSPlusSignature(wotsPlusSignature).withAuthPath(bdsState.get(0).getAuthenticationPath()).build();
                signature.getReducedSignatures().add(reducedSignature);
                for (int layer = 1; layer < this.params.getLayers(); ++layer) {
                    XMSSNode root = bdsState.get(layer - 1).getRoot();
                    indexLeaf = XMSSUtil.getLeafIndex(indexTree, xmssHeight);
                    indexTree = XMSSUtil.getTreeIndex(indexTree, xmssHeight);
                    otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(layer)).withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
                    wotsPlusSignature = this.wotsSign(root.getValue(), otsHashAddress);
                    if (bdsState.get(layer) == null || XMSSUtil.isNewBDSInitNeeded(globalIndex, xmssHeight, layer)) {
                        bdsState.put(layer, new BDS(this.xmssParams, this.privateKey.getPublicSeed(), this.privateKey.getSecretKeySeed(), otsHashAddress));
                    }
                    reducedSignature = new XMSSReducedSignature.Builder(this.xmssParams).withWOTSPlusSignature(wotsPlusSignature).withAuthPath(bdsState.get(layer).getAuthenticationPath()).build();
                    signature.getReducedSignatures().add(reducedSignature);
                }
                byArray = signature.toByteArray();
                this.privateKey.rollKey();
            }
            catch (Throwable throwable) {
                this.privateKey.rollKey();
                throw throwable;
            }
            return byArray;
        }
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (signature == null) {
            throw new NullPointerException("signature == null");
        }
        if (this.publicKey == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTSignature sig = new XMSSMTSignature.Builder(this.params).withSignature(signature).build();
        byte[] concatenated = Arrays.concatenate(sig.getRandom(), this.publicKey.getRoot(), XMSSUtil.toBytesBigEndian(sig.getIndex(), this.params.getTreeDigestSize()));
        byte[] messageDigest = this.wotsPlus.getKhf().HMsg(concatenated, message);
        long globalIndex = sig.getIndex();
        int xmssHeight = this.xmssParams.getHeight();
        long indexTree = XMSSUtil.getTreeIndex(globalIndex, xmssHeight);
        int indexLeaf = XMSSUtil.getLeafIndex(globalIndex, xmssHeight);
        this.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], this.publicKey.getPublicSeed());
        OTSHashAddress otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
        XMSSReducedSignature xmssMTSignature = sig.getReducedSignatures().get(0);
        XMSSNode rootNode = XMSSVerifierUtil.getRootNodeFromSignature(this.wotsPlus, xmssHeight, messageDigest, xmssMTSignature, otsHashAddress, indexLeaf);
        for (int layer = 1; layer < this.params.getLayers(); ++layer) {
            xmssMTSignature = sig.getReducedSignatures().get(layer);
            indexLeaf = XMSSUtil.getLeafIndex(indexTree, xmssHeight);
            indexTree = XMSSUtil.getTreeIndex(indexTree, xmssHeight);
            otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(layer)).withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
            rootNode = XMSSVerifierUtil.getRootNodeFromSignature(this.wotsPlus, xmssHeight, rootNode.getValue(), xmssMTSignature, otsHashAddress, indexLeaf);
        }
        return Arrays.constantTimeAreEqual(rootNode.getValue(), this.publicKey.getRoot());
    }

    private WOTSPlusSignature wotsSign(byte[] messageDigest, OTSHashAddress otsHashAddress) {
        if (messageDigest.length != this.params.getTreeDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (otsHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.wotsPlus.importKeys(this.wotsPlus.getWOTSPlusSecretKey(this.privateKey.getSecretKeySeed(), otsHashAddress), this.privateKey.getPublicSeed());
        return this.wotsPlus.sign(messageDigest, otsHashAddress);
    }

    public long getUsagesRemaining() {
        return this.privateKey.getUsagesRemaining();
    }

    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        if (this.hasGenerated) {
            XMSSMTPrivateKeyParameters privKey = this.privateKey;
            this.privateKey = null;
            return privKey;
        }
        XMSSMTPrivateKeyParameters privKey = this.privateKey;
        if (privKey != null) {
            this.privateKey = this.privateKey.getNextKey();
        }
        return privKey;
    }
}

