/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.jcajce.provider.lms;

import com.apusic.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.apusic.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.apusic.org.bouncycastle.crypto.KeyGenerationParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.HSSKeyGenerationParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.HSSKeyPairGenerator;
import com.apusic.org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSKeyGenerationParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSKeyPairGenerator;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.lms.BCLMSPrivateKey;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.lms.BCLMSPublicKey;
import com.apusic.org.bouncycastle.pqc.jcajce.spec.LMSHSSKeyGenParameterSpec;
import com.apusic.org.bouncycastle.pqc.jcajce.spec.LMSHSSParameterSpec;
import com.apusic.org.bouncycastle.pqc.jcajce.spec.LMSKeyGenParameterSpec;
import com.apusic.org.bouncycastle.pqc.jcajce.spec.LMSParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class LMSKeyPairGeneratorSpi
extends KeyPairGenerator {
    private KeyGenerationParameters param;
    private ASN1ObjectIdentifier treeDigest;
    private AsymmetricCipherKeyPairGenerator engine = new LMSKeyPairGenerator();
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public LMSKeyPairGeneratorSpi() {
        super("LMS");
    }

    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof LMSKeyGenParameterSpec) {
            LMSKeyGenParameterSpec lmsParams = (LMSKeyGenParameterSpec)params;
            this.param = new LMSKeyGenerationParameters(new LMSParameters(lmsParams.getSigParams(), lmsParams.getOtsParams()), random);
            this.engine = new LMSKeyPairGenerator();
            this.engine.init(this.param);
        } else if (params instanceof LMSHSSKeyGenParameterSpec) {
            LMSKeyGenParameterSpec[] lmsParams = ((LMSHSSKeyGenParameterSpec)params).getLMSSpecs();
            LMSParameters[] hssParams = new LMSParameters[lmsParams.length];
            for (int i = 0; i != lmsParams.length; ++i) {
                hssParams[i] = new LMSParameters(lmsParams[i].getSigParams(), lmsParams[i].getOtsParams());
            }
            this.param = new HSSKeyGenerationParameters(hssParams, random);
            this.engine = new HSSKeyPairGenerator();
            this.engine.init(this.param);
        } else if (params instanceof LMSParameterSpec) {
            LMSParameterSpec lmsParams = (LMSParameterSpec)params;
            this.param = new LMSKeyGenerationParameters(new LMSParameters(lmsParams.getSigParams(), lmsParams.getOtsParams()), random);
            this.engine = new LMSKeyPairGenerator();
            this.engine.init(this.param);
        } else if (params instanceof LMSHSSParameterSpec) {
            LMSParameterSpec[] lmsParams = ((LMSHSSParameterSpec)params).getLMSSpecs();
            LMSParameters[] hssParams = new LMSParameters[lmsParams.length];
            for (int i = 0; i != lmsParams.length; ++i) {
                hssParams[i] = new LMSParameters(lmsParams[i].getSigParams(), lmsParams[i].getOtsParams());
            }
            this.param = new HSSKeyGenerationParameters(hssParams, random);
            this.engine = new HSSKeyPairGenerator();
            this.engine.init(this.param);
        } else {
            throw new InvalidAlgorithmParameterException("parameter object not a LMSParameterSpec/LMSHSSParameterSpec");
        }
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new LMSKeyGenerationParameters(new LMSParameters(LMSigParameters.lms_sha256_n32_h10, LMOtsParameters.sha256_n32_w2), this.random);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        if (this.engine instanceof LMSKeyPairGenerator) {
            LMSPublicKeyParameters pub = (LMSPublicKeyParameters)pair.getPublic();
            LMSPrivateKeyParameters priv = (LMSPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new BCLMSPublicKey(pub), new BCLMSPrivateKey(priv));
        }
        HSSPublicKeyParameters pub = (HSSPublicKeyParameters)pair.getPublic();
        HSSPrivateKeyParameters priv = (HSSPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCLMSPublicKey(pub), new BCLMSPrivateKey(priv));
    }
}

