/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.jcajce.provider.mceliece;

import com.apusic.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.apusic.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.apusic.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.apusic.org.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import com.apusic.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.apusic.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.mceliece.Utils;
import com.apusic.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.apusic.org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.apusic.org.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.apusic.org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.io.IOException;
import java.security.PrivateKey;

public class BCMcElieceCCA2PrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private McElieceCCA2PrivateKeyParameters params;

    public BCMcElieceCCA2PrivateKey(McElieceCCA2PrivateKeyParameters params) {
        this.params = params;
    }

    public String getAlgorithm() {
        return "McEliece-CCA2";
    }

    public int getN() {
        return this.params.getN();
    }

    public int getK() {
        return this.params.getK();
    }

    public int getT() {
        return this.params.getGoppaPoly().getDegree();
    }

    public GF2mField getField() {
        return this.params.getField();
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.params.getGoppaPoly();
    }

    public Permutation getP() {
        return this.params.getP();
    }

    public GF2Matrix getH() {
        return this.params.getH();
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.params.getQInv();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BCMcElieceCCA2PrivateKey)) {
            return false;
        }
        BCMcElieceCCA2PrivateKey otherKey = (BCMcElieceCCA2PrivateKey)other;
        return this.getN() == otherKey.getN() && this.getK() == otherKey.getK() && this.getField().equals(otherKey.getField()) && this.getGoppaPoly().equals(otherKey.getGoppaPoly()) && this.getP().equals(otherKey.getP()) && this.getH().equals(otherKey.getH());
    }

    public int hashCode() {
        int code = this.params.getK();
        code = code * 37 + this.params.getN();
        code = code * 37 + this.params.getField().hashCode();
        code = code * 37 + this.params.getGoppaPoly().hashCode();
        code = code * 37 + this.params.getP().hashCode();
        return code * 37 + this.params.getH().hashCode();
    }

    public byte[] getEncoded() {
        try {
            McElieceCCA2PrivateKey privateKey = new McElieceCCA2PrivateKey(this.getN(), this.getK(), this.getField(), this.getGoppaPoly(), this.getP(), Utils.getDigAlgId(this.params.getDigest()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            PrivateKeyInfo pki = new PrivateKeyInfo(algorithmIdentifier, privateKey);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

