/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.jcajce.provider.newhope;

import com.apusic.org.bouncycastle.asn1.ASN1Set;
import com.apusic.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.apusic.org.bouncycastle.crypto.CipherParameters;
import com.apusic.org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.apusic.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.apusic.org.bouncycastle.pqc.jcajce.interfaces.NHPrivateKey;
import com.apusic.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BCNHPrivateKey
implements NHPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient NHPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCNHPrivateKey(NHPrivateKeyParameters params) {
        this.params = params;
    }

    public BCNHPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(PrivateKeyInfo keyInfo) throws IOException {
        this.attributes = keyInfo.getAttributes();
        this.params = (NHPrivateKeyParameters)PrivateKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BCNHPrivateKey)) {
            return false;
        }
        BCNHPrivateKey otherKey = (BCNHPrivateKey)o;
        return Arrays.areEqual(this.params.getSecData(), otherKey.params.getSecData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getSecData());
    }

    public final String getAlgorithm() {
        return "NH";
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo pki = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public short[] getSecretData() {
        return this.params.getSecData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

