/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.pqc.jcajce.provider.rainbow;

import com.apusic.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.apusic.org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.apusic.org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPrivateKey;
import com.apusic.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class RainbowKeysToParams {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof BCRainbowPublicKey) {
            BCRainbowPublicKey k = (BCRainbowPublicKey)key;
            return new RainbowPublicKeyParameters(k.getDocLength(), k.getCoeffQuadratic(), k.getCoeffSingular(), k.getCoeffScalar());
        }
        throw new InvalidKeyException("can't identify Rainbow public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof BCRainbowPrivateKey) {
            BCRainbowPrivateKey k = (BCRainbowPrivateKey)key;
            return new RainbowPrivateKeyParameters(k.getInvA1(), k.getB1(), k.getInvA2(), k.getB2(), k.getVi(), k.getLayers());
        }
        throw new InvalidKeyException("can't identify Rainbow private key.");
    }
}

