/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

class DTLSReplayWindow {
    private static final long VALID_SEQ_MASK = 0xFFFFFFFFFFFFL;
    private static final long WINDOW_SIZE = 64L;
    private long latestConfirmedSeq = -1L;
    private long bitmap = 0L;

    DTLSReplayWindow() {
    }

    boolean shouldDiscard(long seq) {
        if ((seq & 0xFFFFFFFFFFFFL) != seq) {
            return true;
        }
        if (seq <= this.latestConfirmedSeq) {
            long diff = this.latestConfirmedSeq - seq;
            if (diff >= 64L) {
                return true;
            }
            if ((this.bitmap & 1L << (int)diff) != 0L) {
                return true;
            }
        }
        return false;
    }

    void reportAuthenticated(long seq) {
        if ((seq & 0xFFFFFFFFFFFFL) != seq) {
            throw new IllegalArgumentException("'seq' out of range");
        }
        if (seq <= this.latestConfirmedSeq) {
            long diff = this.latestConfirmedSeq - seq;
            if (diff < 64L) {
                this.bitmap |= 1L << (int)diff;
            }
        } else {
            long diff = seq - this.latestConfirmedSeq;
            if (diff >= 64L) {
                this.bitmap = 1L;
            } else {
                this.bitmap <<= (int)diff;
                this.bitmap |= 1L;
            }
            this.latestConfirmedSeq = seq;
        }
    }

    void reset(long seq) {
        if ((seq & 0xFFFFFFFFFFFFL) != seq) {
            throw new IllegalArgumentException("'seq' out of range");
        }
        this.latestConfirmedSeq = seq;
        this.bitmap = -1L >>> (int)Math.max(0L, 63L - seq);
    }
}

