/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.tls.CombinedHash;
import com.apusic.org.bouncycastle.tls.DigestInputBuffer;
import com.apusic.org.bouncycastle.tls.SecurityParameters;
import com.apusic.org.bouncycastle.tls.TlsContext;
import com.apusic.org.bouncycastle.tls.TlsHandshakeHash;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.tls.crypto.TlsHash;
import com.apusic.org.bouncycastle.util.Integers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable hashes;
    private boolean forceBuffering;
    private boolean sealed;

    DeferredHash(TlsContext context) {
        this.context = context;
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.forceBuffering = false;
        this.sealed = false;
    }

    private DeferredHash(TlsContext context, Hashtable hashes) {
        this.context = context;
        this.buf = null;
        this.hashes = hashes;
        this.forceBuffering = false;
        this.sealed = true;
    }

    public void copyBufferTo(OutputStream output) throws IOException {
        if (this.buf == null) {
            throw new IllegalStateException("Not buffering");
        }
        this.buf.copyTo(output);
    }

    public void forceBuffering() {
        if (this.sealed) {
            throw new IllegalStateException("Too late to force buffering");
        }
        this.forceBuffering = true;
    }

    public void notifyPRFDetermined() {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                this.checkTrackingHash(1);
                this.checkTrackingHash(2);
                break;
            }
            default: {
                this.checkTrackingHash(securityParameters.getPRFHashAlgorithm());
                if (!TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) break;
                this.sealHashAlgorithms();
            }
        }
    }

    public void trackHashAlgorithm(int cryptoHashAlgorithm) {
        if (this.sealed) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(cryptoHashAlgorithm);
    }

    public void sealHashAlgorithms() {
        if (this.sealed) {
            throw new IllegalStateException("Already sealed");
        }
        this.sealed = true;
        this.checkStopBuffering();
    }

    public TlsHandshakeHash stopTracking() {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        Hashtable newHashes = new Hashtable();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                this.cloneHash(newHashes, 1);
                this.cloneHash(newHashes, 2);
                break;
            }
            default: {
                this.cloneHash(newHashes, securityParameters.getPRFHashAlgorithm());
            }
        }
        return new DeferredHash(this.context, newHashes);
    }

    public TlsHash forkPRFHash() {
        TlsHash prfHash;
        this.checkStopBuffering();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                prfHash = new CombinedHash(this.context, this.cloneHash(1), this.cloneHash(2));
                break;
            }
            default: {
                prfHash = this.cloneHash(securityParameters.getPRFHashAlgorithm());
            }
        }
        if (this.buf != null) {
            this.buf.updateDigest(prfHash);
        }
        return prfHash;
    }

    public byte[] getFinalHash(int cryptoHashAlgorithm) {
        TlsHash d = (TlsHash)this.hashes.get(this.box(cryptoHashAlgorithm));
        if (d == null) {
            throw new IllegalStateException("CryptoHashAlgorithm." + cryptoHashAlgorithm + " is not being tracked");
        }
        this.checkStopBuffering();
        d = d.cloneHash();
        if (this.buf != null) {
            this.buf.updateDigest(d);
        }
        return d.calculateHash();
    }

    public void update(byte[] input, int inOff, int len) {
        if (this.buf != null) {
            this.buf.write(input, inOff, len);
            return;
        }
        Enumeration e = this.hashes.elements();
        while (e.hasMoreElements()) {
            TlsHash hash = (TlsHash)e.nextElement();
            hash.update(input, inOff, len);
        }
    }

    public byte[] calculateHash() {
        throw new IllegalStateException("Use 'forkPRFHash' to get a definite hash");
    }

    public TlsHash cloneHash() {
        throw new IllegalStateException("attempt to clone a DeferredHash");
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration e = this.hashes.elements();
        while (e.hasMoreElements()) {
            TlsHash hash = (TlsHash)e.nextElement();
            hash.reset();
        }
    }

    protected Integer box(int cryptoHashAlgorithm) {
        return Integers.valueOf(cryptoHashAlgorithm);
    }

    protected void checkStopBuffering() {
        if (!this.forceBuffering && this.sealed && this.buf != null && this.hashes.size() <= 4) {
            Enumeration e = this.hashes.elements();
            while (e.hasMoreElements()) {
                TlsHash hash = (TlsHash)e.nextElement();
                this.buf.updateDigest(hash);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(int cryptoHashAlgorithm) {
        this.checkTrackingHash(this.box(cryptoHashAlgorithm));
    }

    protected void checkTrackingHash(Integer cryptoHashAlgorithm) {
        if (!this.hashes.containsKey(cryptoHashAlgorithm)) {
            TlsHash hash = this.context.getCrypto().createHash(cryptoHashAlgorithm);
            this.hashes.put(cryptoHashAlgorithm, hash);
        }
    }

    protected TlsHash cloneHash(int cryptoHashAlgorithm) {
        return this.cloneHash(this.box(cryptoHashAlgorithm));
    }

    protected TlsHash cloneHash(Integer cryptoHashAlgorithm) {
        return ((TlsHash)this.hashes.get(cryptoHashAlgorithm)).cloneHash();
    }

    protected void cloneHash(Hashtable newHashes, int cryptoHashAlgorithm) {
        this.cloneHash(newHashes, this.box(cryptoHashAlgorithm));
    }

    protected void cloneHash(Hashtable newHashes, Integer cryptoHashAlgorithm) {
        TlsHash hash = this.cloneHash(cryptoHashAlgorithm);
        if (this.buf != null) {
            this.buf.updateDigest(hash);
        }
        newHashes.put(cryptoHashAlgorithm, hash);
    }
}

