/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.tls.AbstractTlsClient;
import com.apusic.org.bouncycastle.tls.BasicTlsPSKIdentity;
import com.apusic.org.bouncycastle.tls.ProtocolVersion;
import com.apusic.org.bouncycastle.tls.TlsAuthentication;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.TlsPSKIdentity;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.tls.crypto.TlsCrypto;
import java.io.IOException;

public class PSKTlsClient
extends AbstractTlsClient {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{52396, 49207, 49205, 52397, 170, 178, 144};
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsCrypto crypto, byte[] identity, byte[] psk) {
        this(crypto, new BasicTlsPSKIdentity(identity, psk));
    }

    public PSKTlsClient(TlsCrypto crypto, TlsPSKIdentity pskIdentity) {
        super(crypto);
        this.pskIdentity = pskIdentity;
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.downTo(ProtocolVersion.TLSv10);
    }

    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    public TlsPSKIdentity getPSKIdentity() {
        return this.pskIdentity;
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }
}

