/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.tls.ContentType;
import com.apusic.org.bouncycastle.tls.ProtocolVersion;
import com.apusic.org.bouncycastle.tls.RecordPreview;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.TlsProtocol;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.tls.crypto.TlsCipher;
import com.apusic.org.bouncycastle.tls.crypto.TlsDecodeResult;
import com.apusic.org.bouncycastle.tls.crypto.TlsEncodeResult;
import com.apusic.org.bouncycastle.tls.crypto.TlsNullNullCipher;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class RecordStream {
    private static int DEFAULT_PLAINTEXT_LIMIT = 16384;
    private final Record inputRecord = new Record();
    private final SequenceNumber readSeqNo = new SequenceNumber();
    private final SequenceNumber writeSeqNo = new SequenceNumber();
    private TlsProtocol handler;
    private InputStream input;
    private OutputStream output;
    private TlsCipher pendingCipher = null;
    private TlsCipher readCipher = TlsNullNullCipher.INSTANCE;
    private TlsCipher readCipherDeferred = null;
    private TlsCipher writeCipher = TlsNullNullCipher.INSTANCE;
    private ProtocolVersion writeVersion = null;
    private int plaintextLimit = DEFAULT_PLAINTEXT_LIMIT;
    private int ciphertextLimit = DEFAULT_PLAINTEXT_LIMIT;
    private boolean ignoreChangeCipherSpec = false;

    RecordStream(TlsProtocol handler, InputStream input, OutputStream output) {
        this.handler = handler;
        this.input = input;
        this.output = output;
    }

    int getPlaintextLimit() {
        return this.plaintextLimit;
    }

    void setPlaintextLimit(int plaintextLimit) {
        this.plaintextLimit = plaintextLimit;
        this.ciphertextLimit = this.readCipher.getCiphertextDecodeLimit(plaintextLimit);
    }

    void setWriteVersion(ProtocolVersion writeVersion) {
        this.writeVersion = writeVersion;
    }

    void setIgnoreChangeCipherSpec(boolean ignoreChangeCipherSpec) {
        this.ignoreChangeCipherSpec = ignoreChangeCipherSpec;
    }

    void setPendingCipher(TlsCipher tlsCipher) {
        this.pendingCipher = tlsCipher;
    }

    void notifyChangeCipherSpecReceived() throws IOException {
        if (this.pendingCipher == null) {
            throw new TlsFatalAlert(10, "No pending cipher");
        }
        this.enablePendingCipherRead(false);
    }

    void enablePendingCipherRead(boolean deferred) throws IOException {
        if (this.pendingCipher == null) {
            throw new TlsFatalAlert(80);
        }
        if (this.readCipherDeferred != null) {
            throw new TlsFatalAlert(80);
        }
        if (deferred) {
            this.readCipherDeferred = this.pendingCipher;
        } else {
            this.readCipher = this.pendingCipher;
            this.ciphertextLimit = this.readCipher.getCiphertextDecodeLimit(this.plaintextLimit);
            this.readSeqNo.reset();
        }
    }

    void enablePendingCipherWrite() throws IOException {
        if (this.pendingCipher == null) {
            throw new TlsFatalAlert(80);
        }
        this.writeCipher = this.pendingCipher;
        this.writeSeqNo.reset();
    }

    void finaliseHandshake() throws IOException {
        if (this.readCipher != this.pendingCipher || this.writeCipher != this.pendingCipher) {
            throw new TlsFatalAlert(40);
        }
        this.pendingCipher = null;
    }

    boolean needsKeyUpdate() {
        return this.writeSeqNo.currentValue() >= 0x100000L;
    }

    void notifyKeyUpdateReceived() throws IOException {
        this.readCipher.rekeyDecoder();
        this.readSeqNo.reset();
    }

    void notifyKeyUpdateSent() throws IOException {
        this.writeCipher.rekeyEncoder();
        this.writeSeqNo.reset();
    }

    RecordPreview previewRecordHeader(byte[] recordHeader) throws IOException {
        short recordType = this.checkRecordType(recordHeader, 0);
        int length = TlsUtils.readUint16(recordHeader, 3);
        RecordStream.checkLength(length, this.ciphertextLimit, (short)22);
        int recordSize = 5 + length;
        int applicationDataLimit = 0;
        if (23 == recordType && this.handler.isApplicationDataReady()) {
            applicationDataLimit = Math.max(0, Math.min(this.plaintextLimit, this.readCipher.getPlaintextLimit(length)));
        }
        return new RecordPreview(recordSize, applicationDataLimit);
    }

    RecordPreview previewOutputRecord(int contentLength) {
        int contentLimit = Math.max(0, Math.min(this.plaintextLimit, contentLength));
        int recordSize = this.previewOutputRecordSize(contentLimit);
        return new RecordPreview(recordSize, contentLimit);
    }

    int previewOutputRecordSize(int contentLength) {
        return 5 + this.writeCipher.getCiphertextEncodeLimit(contentLength, this.plaintextLimit);
    }

    boolean readFullRecord(byte[] input, int inputOff, int inputLen) throws IOException {
        if (inputLen < 5) {
            return false;
        }
        int length = TlsUtils.readUint16(input, inputOff + 3);
        if (inputLen != 5 + length) {
            return false;
        }
        short recordType = this.checkRecordType(input, inputOff + 0);
        ProtocolVersion recordVersion = TlsUtils.readVersion(input, inputOff + 1);
        RecordStream.checkLength(length, this.ciphertextLimit, (short)22);
        if (this.ignoreChangeCipherSpec && 20 == recordType) {
            this.checkChangeCipherSpec(input, inputOff + 5, length);
            return true;
        }
        TlsDecodeResult decoded = this.decodeAndVerify(recordType, recordVersion, input, inputOff + 5, length);
        this.handler.processRecord(decoded.contentType, decoded.buf, decoded.off, decoded.len);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readRecord() throws IOException {
        TlsDecodeResult decoded;
        if (!this.inputRecord.readHeader(this.input)) {
            return false;
        }
        short recordType = this.checkRecordType(this.inputRecord.buf, 0);
        ProtocolVersion recordVersion = TlsUtils.readVersion(this.inputRecord.buf, 1);
        int length = TlsUtils.readUint16(this.inputRecord.buf, 3);
        RecordStream.checkLength(length, this.ciphertextLimit, (short)22);
        this.inputRecord.readFragment(this.input, length);
        try {
            if (this.ignoreChangeCipherSpec && 20 == recordType) {
                this.checkChangeCipherSpec(this.inputRecord.buf, 5, length);
                boolean bl = true;
                return bl;
            }
            decoded = this.decodeAndVerify(recordType, recordVersion, this.inputRecord.buf, 5, length);
        }
        finally {
            this.inputRecord.reset();
        }
        this.handler.processRecord(decoded.contentType, decoded.buf, decoded.off, decoded.len);
        return true;
    }

    TlsDecodeResult decodeAndVerify(short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int off, int len) throws IOException {
        long seqNo = this.readSeqNo.nextValue((short)10);
        TlsDecodeResult decoded = this.readCipher.decodeCiphertext(seqNo, recordType, recordVersion, ciphertext, off, len);
        RecordStream.checkLength(decoded.len, this.plaintextLimit, (short)22);
        if (decoded.len < 1 && decoded.contentType != 23) {
            throw new TlsFatalAlert(47);
        }
        return decoded;
    }

    void writeRecord(short contentType, byte[] plaintext, int plaintextOffset, int plaintextLength) throws IOException {
        if (this.writeVersion == null) {
            return;
        }
        RecordStream.checkLength(plaintextLength, this.plaintextLimit, (short)80);
        if (plaintextLength < 1 && contentType != 23) {
            throw new TlsFatalAlert(80);
        }
        long seqNo = this.writeSeqNo.nextValue((short)80);
        ProtocolVersion recordVersion = this.writeVersion;
        TlsEncodeResult encoded = this.writeCipher.encodePlaintext(seqNo, contentType, recordVersion, 5, plaintext, plaintextOffset, plaintextLength);
        int ciphertextLength = encoded.len - 5;
        TlsUtils.checkUint16(ciphertextLength);
        TlsUtils.writeUint8(encoded.recordType, encoded.buf, encoded.off + 0);
        TlsUtils.writeVersion(recordVersion, encoded.buf, encoded.off + 1);
        TlsUtils.writeUint16(ciphertextLength, encoded.buf, encoded.off + 3);
        try {
            this.output.write(encoded.buf, encoded.off, encoded.len);
        }
        catch (InterruptedIOException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        this.output.flush();
    }

    void close() throws IOException {
        IOException io;
        block5: {
            this.inputRecord.reset();
            io = null;
            try {
                this.input.close();
            }
            catch (IOException e) {
                io = e;
            }
            try {
                this.output.close();
            }
            catch (IOException e) {
                if (io != null) break block5;
                io = e;
            }
        }
        if (io != null) {
            throw io;
        }
    }

    private void checkChangeCipherSpec(byte[] buf, int off, int len) throws IOException {
        if (1 != len || 1 != buf[off]) {
            throw new TlsFatalAlert(10, "Malformed " + ContentType.getText((short)20));
        }
    }

    private short checkRecordType(byte[] buf, int off) throws IOException {
        short recordType = TlsUtils.readUint8(buf, off);
        if (null != this.readCipherDeferred && recordType == 23) {
            this.readCipher = this.readCipherDeferred;
            this.readCipherDeferred = null;
            this.ciphertextLimit = this.readCipher.getCiphertextDecodeLimit(this.plaintextLimit);
            this.readSeqNo.reset();
        } else if (this.readCipher.usesOpaqueRecordType()) {
            if (!(23 == recordType || this.ignoreChangeCipherSpec && 20 == recordType)) {
                throw new TlsFatalAlert(10, "Opaque " + ContentType.getText(recordType));
            }
        } else {
            switch (recordType) {
                case 23: {
                    if (this.handler.isApplicationDataReady()) break;
                    throw new TlsFatalAlert(10, "Not ready for " + ContentType.getText((short)23));
                }
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                default: {
                    throw new TlsFatalAlert(10, "Unsupported " + ContentType.getText(recordType));
                }
            }
        }
        return recordType;
    }

    private static void checkLength(int length, int limit, short alertDescription) throws IOException {
        if (length > limit) {
            throw new TlsFatalAlert(alertDescription);
        }
    }

    private static class SequenceNumber {
        private long value = 0L;
        private boolean exhausted = false;

        private SequenceNumber() {
        }

        synchronized long currentValue() {
            return this.value;
        }

        synchronized long nextValue(short alertDescription) throws TlsFatalAlert {
            if (this.exhausted) {
                throw new TlsFatalAlert(alertDescription, "Sequence numbers exhausted");
            }
            long result = this.value++;
            if (this.value == 0L) {
                this.exhausted = true;
            }
            return result;
        }

        synchronized void reset() {
            this.value = 0L;
            this.exhausted = false;
        }
    }

    private static class Record {
        private final byte[] header = new byte[5];
        volatile byte[] buf = this.header;
        volatile int pos = 0;

        private Record() {
        }

        void fillTo(InputStream input, int length) throws IOException {
            while (this.pos < length) {
                try {
                    int numRead = input.read(this.buf, this.pos, length - this.pos);
                    if (numRead < 0) break;
                    this.pos += numRead;
                }
                catch (InterruptedIOException e) {
                    this.pos += e.bytesTransferred;
                    e.bytesTransferred = 0;
                    throw e;
                }
            }
        }

        void readFragment(InputStream input, int fragmentLength) throws IOException {
            int recordLength = 5 + fragmentLength;
            this.resize(recordLength);
            this.fillTo(input, recordLength);
            if (this.pos < recordLength) {
                throw new EOFException();
            }
        }

        boolean readHeader(InputStream input) throws IOException {
            this.fillTo(input, 5);
            if (this.pos == 0) {
                return false;
            }
            if (this.pos < 5) {
                throw new EOFException();
            }
            return true;
        }

        void reset() {
            this.buf = this.header;
            this.pos = 0;
        }

        private void resize(int length) {
            if (this.buf.length < length) {
                byte[] tmp = new byte[length];
                System.arraycopy(this.buf, 0, tmp, 0, this.pos);
                this.buf = tmp;
            }
        }
    }
}

