/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls;

import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.util.BigIntegers;
import com.apusic.org.bouncycastle.util.Integers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Hashtable;

public class TlsSRPUtils {
    public static final Integer EXT_SRP = Integers.valueOf(12);

    public static void addSRPExtension(Hashtable extensions, byte[] identity) throws IOException {
        extensions.put(EXT_SRP, TlsSRPUtils.createSRPExtension(identity));
    }

    public static byte[] getSRPExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_SRP);
        return extensionData == null ? null : TlsSRPUtils.readSRPExtension(extensionData);
    }

    public static byte[] createSRPExtension(byte[] identity) throws IOException {
        if (identity == null) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeOpaque8(identity);
    }

    public static byte[] readSRPExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        return TlsUtils.decodeOpaque8(extensionData, 1);
    }

    public static BigInteger readSRPParameter(InputStream input) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(input, 1));
    }

    public static void writeSRPParameter(BigInteger x, OutputStream output) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray(x), output);
    }

    public static boolean isSRPCipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }
}

