/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl;

import com.apusic.org.bouncycastle.tls.crypto.TlsCertificate;
import com.apusic.org.bouncycastle.tls.crypto.TlsSecret;
import com.apusic.org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import com.apusic.org.bouncycastle.util.Arrays;
import java.io.IOException;

public abstract class AbstractTlsSecret
implements TlsSecret {
    protected byte[] data;

    protected AbstractTlsSecret(byte[] data) {
        this.data = data;
    }

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();

    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill(this.data, (byte)0);
            this.data = null;
        }
    }

    public synchronized byte[] encrypt(TlsCertificate certificate) throws IOException {
        this.checkAlive();
        return this.getCrypto().createEncryptor(certificate).encrypt(this.data, 0, this.data.length);
    }

    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] result = this.data;
        this.data = null;
        return result;
    }

    public synchronized boolean isAlive() {
        return null != this.data;
    }

    synchronized byte[] copyData() {
        return Arrays.clone(this.data);
    }
}

