/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl;

import com.apusic.org.bouncycastle.tls.ProtocolVersion;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.apusic.org.bouncycastle.tls.crypto.TlsHMAC;
import com.apusic.org.bouncycastle.tls.crypto.TlsMAC;
import com.apusic.org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import com.apusic.org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import com.apusic.org.bouncycastle.util.Arrays;

public class TlsSuiteHMac
implements TlsSuiteMac {
    protected final TlsCryptoParameters cryptoParams;
    protected final TlsHMAC mac;
    protected final int digestBlockSize;
    protected final int digestOverhead;
    protected final int macSize;

    protected static int getMacSize(TlsCryptoParameters cryptoParams, TlsMAC mac) {
        int macSize = mac.getMacLength();
        if (cryptoParams.getSecurityParametersHandshake().isTruncatedHMac()) {
            macSize = Math.min(macSize, 10);
        }
        return macSize;
    }

    public TlsSuiteHMac(TlsCryptoParameters cryptoParams, TlsHMAC mac) {
        this.cryptoParams = cryptoParams;
        this.mac = mac;
        this.macSize = TlsSuiteHMac.getMacSize(cryptoParams, mac);
        this.digestBlockSize = mac.getInternalBlockSize();
        this.digestOverhead = TlsImplUtils.isSSL(cryptoParams) && mac.getMacLength() == 20 ? 4 : this.digestBlockSize / 8;
    }

    public int getSize() {
        return this.macSize;
    }

    public byte[] calculateMac(long seqNo, short type, byte[] msg, int msgOff, int msgLen) {
        ProtocolVersion serverVersion = this.cryptoParams.getServerVersion();
        boolean isSSL = serverVersion.isSSL();
        byte[] macHeader = new byte[isSSL ? 11 : 13];
        TlsUtils.writeUint64(seqNo, macHeader, 0);
        TlsUtils.writeUint8(type, macHeader, 8);
        if (!isSSL) {
            TlsUtils.writeVersion(serverVersion, macHeader, 9);
        }
        TlsUtils.writeUint16(msgLen, macHeader, macHeader.length - 2);
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(msg, msgOff, msgLen);
        return this.truncate(this.mac.calculateMAC());
    }

    public byte[] calculateMacConstantTime(long seqNo, short type, byte[] msg, int msgOff, int msgLen, int fullLength, byte[] dummyData) {
        byte[] result = this.calculateMac(seqNo, type, msg, msgOff, msgLen);
        int headerLength = TlsImplUtils.isSSL(this.cryptoParams) ? 11 : 13;
        int extra = this.getDigestBlockCount(headerLength + fullLength) - this.getDigestBlockCount(headerLength + msgLen);
        while (--extra >= 0) {
            this.mac.update(dummyData, 0, this.digestBlockSize);
        }
        this.mac.update(dummyData, 0, 1);
        this.mac.reset();
        return result;
    }

    protected int getDigestBlockCount(int inputLength) {
        return (inputLength + this.digestOverhead) / this.digestBlockSize;
    }

    protected byte[] truncate(byte[] bs) {
        if (bs.length <= this.macSize) {
            return bs;
        }
        return Arrays.copyOf(bs, this.macSize);
    }
}

