/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.apusic.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.apusic.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.apusic.org.bouncycastle.tls.crypto.TlsAgreement;
import com.apusic.org.bouncycastle.tls.crypto.TlsSecret;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import java.io.IOException;

public class BcTlsDH
implements TlsAgreement {
    protected final BcTlsDHDomain domain;
    protected AsymmetricCipherKeyPair localKeyPair;
    protected DHPublicKeyParameters peerPublicKey;

    public BcTlsDH(BcTlsDHDomain domain) {
        this.domain = domain;
    }

    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((DHPublicKeyParameters)this.localKeyPair.getPublic());
    }

    public void receivePeerValue(byte[] peerValue) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(peerValue);
    }

    public TlsSecret calculateSecret() throws IOException {
        return this.domain.calculateDHAgreement((DHPrivateKeyParameters)this.localKeyPair.getPrivate(), this.peerPublicKey);
    }
}

