/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.digests.NullDigest;
import com.apusic.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.apusic.org.bouncycastle.crypto.signers.DSADigestSigner;
import com.apusic.org.bouncycastle.crypto.signers.ECDSASigner;
import com.apusic.org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import com.apusic.org.bouncycastle.tls.DigitallySigned;
import com.apusic.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.apusic.org.bouncycastle.tls.SignatureScheme;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsECDSA13Verifier
extends BcTlsVerifier {
    private final int signatureScheme;

    public BcTlsECDSA13Verifier(BcTlsCrypto crypto, ECPublicKeyParameters publicKey, int signatureScheme) {
        super(crypto, publicKey);
        if (!SignatureScheme.isECDSA(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = signatureScheme;
    }

    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null || SignatureScheme.from(algorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        ECDSASigner dsa = new ECDSASigner(new HMacDSAKCalculator(this.crypto.createDigest(cryptoHashAlgorithm)));
        DSADigestSigner signer = new DSADigestSigner(dsa, new NullDigest());
        signer.init(false, this.publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(signature.getSignature());
    }
}

