/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.apusic.org.bouncycastle.crypto.signers.Ed25519Signer;
import com.apusic.org.bouncycastle.tls.DigitallySigned;
import com.apusic.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.apusic.org.bouncycastle.tls.SignatureScheme;
import com.apusic.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamVerifier;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;
import java.io.IOException;

public class BcTlsEd25519Verifier
extends BcTlsVerifier {
    public BcTlsEd25519Verifier(BcTlsCrypto crypto, Ed25519PublicKeyParameters publicKey) {
        super(crypto, publicKey);
    }

    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null || SignatureScheme.from(algorithm) != 2055) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        Ed25519Signer verifier = new Ed25519Signer();
        verifier.init(false, this.publicKey);
        return new BcTlsStreamVerifier(verifier, signature.getSignature());
    }
}

