/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.CryptoException;
import com.apusic.org.bouncycastle.crypto.Signer;
import com.apusic.org.bouncycastle.crypto.digests.NullDigest;
import com.apusic.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.apusic.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.apusic.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.apusic.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.apusic.org.bouncycastle.crypto.signers.GenericSigner;
import com.apusic.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.apusic.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public class BcTlsRSASigner
extends BcTlsSigner {
    private final RSAKeyParameters publicKey;

    public BcTlsRSASigner(BcTlsCrypto crypto, RSAKeyParameters privateKey, RSAKeyParameters publicKey) {
        super(crypto, privateKey);
        this.publicKey = publicKey;
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        Signer signer;
        NullDigest nullDigest = new NullDigest();
        if (algorithm != null) {
            if (algorithm.getSignature() != 1) {
                throw new IllegalStateException("Invalid algorithm: " + algorithm);
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        try {
            byte[] signature = signer.generateSignature();
            signer.init(false, this.publicKey);
            signer.update(hash, 0, hash.length);
            if (signer.verifySignature(signature)) {
                return signature;
            }
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        throw new TlsFatalAlert(80);
    }
}

