/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.apusic.org.bouncycastle.crypto.params.ParametersWithID;
import com.apusic.org.bouncycastle.crypto.signers.SM2Signer;
import com.apusic.org.bouncycastle.tls.DigitallySigned;
import com.apusic.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.apusic.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamVerifier;
import com.apusic.org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;
import com.apusic.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class BcTlsSM2Verifier
extends BcTlsVerifier {
    protected final byte[] identifier;

    public BcTlsSM2Verifier(BcTlsCrypto crypto, ECPublicKeyParameters publicKey, byte[] identifier) {
        super(crypto, publicKey);
        this.identifier = Arrays.clone(identifier);
    }

    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        ParametersWithID parametersWithID = new ParametersWithID(this.publicKey, this.identifier);
        SM2Signer verifier = new SM2Signer();
        verifier.init(false, parametersWithID);
        return new BcTlsStreamVerifier(verifier, signature.getSignature());
    }
}

