/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.bc;

import com.apusic.org.bouncycastle.crypto.CryptoException;
import com.apusic.org.bouncycastle.crypto.agreement.srp.SRP6Client;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.crypto.TlsSRP6Client;
import java.math.BigInteger;

final class BcTlsSRP6Client
implements TlsSRP6Client {
    private final SRP6Client srp6Client;

    BcTlsSRP6Client(SRP6Client srpClient) {
        this.srp6Client = srpClient;
    }

    public BigInteger calculateSecret(BigInteger serverB) throws TlsFatalAlert {
        try {
            return this.srp6Client.calculateSecret(serverB);
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    public BigInteger generateClientCredentials(byte[] srpSalt, byte[] identity, byte[] password) {
        return this.srp6Client.generateClientCredentials(srpSalt, identity, password);
    }
}

