/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.jcajce;

import com.apusic.org.bouncycastle.crypto.digests.SHA512Digest;
import com.apusic.org.bouncycastle.crypto.prng.SP800SecureRandom;
import com.apusic.org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import com.apusic.org.bouncycastle.tls.crypto.TlsNonceGenerator;
import java.security.SecureRandom;

class JcaNonceGenerator
implements TlsNonceGenerator {
    private final SP800SecureRandom random;

    JcaNonceGenerator(SecureRandom entropySource, byte[] additionalData) {
        byte[] nonce = new byte[32];
        entropySource.nextBytes(nonce);
        this.random = new SP800SecureRandomBuilder(entropySource, false).setPersonalizationString(additionalData).buildHash(new SHA512Digest(), nonce, false);
    }

    public byte[] generateNonce(int size) {
        byte[] nonce = new byte[size];
        this.random.nextBytes(nonce);
        return nonce;
    }
}

