/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.jcajce;

import com.apusic.org.bouncycastle.jcajce.util.JcaJceHelper;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.TlsUtils;
import com.apusic.org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import com.apusic.org.bouncycastle.util.Pack;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JceChaCha20Poly1305
implements TlsAEADCipherImpl {
    private static final int BUF_SIZE = 32768;
    private static final byte[] ZEROES = new byte[15];
    protected final Cipher cipher;
    protected final Mac mac;
    protected final int cipherMode;
    protected SecretKey cipherKey;
    protected byte[] additionalData;

    public JceChaCha20Poly1305(JcaJceHelper helper, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = helper.createCipher("ChaCha7539");
        this.mac = helper.createMac("Poly1305");
        this.cipherMode = isEncrypting ? 1 : 2;
    }

    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] extraInput, byte[] output, int outputOffset) throws IOException {
        try {
            boolean badMac;
            int extraInputLength = extraInput.length;
            if (this.cipherMode == 1) {
                int ciphertextLength = inputLength + extraInputLength;
                byte[] tmp = new byte[64 + ciphertextLength];
                System.arraycopy(input, inputOffset, tmp, 64, inputLength);
                System.arraycopy(extraInput, 0, tmp, 64 + inputLength, extraInputLength);
                this.runCipher(tmp);
                System.arraycopy(tmp, 64, output, outputOffset, ciphertextLength);
                this.initMAC(tmp);
                this.updateMAC(this.additionalData, 0, this.additionalData.length);
                this.updateMAC(tmp, 64, ciphertextLength);
                byte[] lengths = new byte[16];
                Pack.longToLittleEndian((long)this.additionalData.length & 0xFFFFFFFFL, lengths, 0);
                Pack.longToLittleEndian((long)ciphertextLength & 0xFFFFFFFFL, lengths, 8);
                this.mac.update(lengths, 0, 16);
                this.mac.doFinal(output, outputOffset + ciphertextLength);
                return ciphertextLength + 16;
            }
            if (extraInputLength > 0) {
                throw new TlsFatalAlert(80);
            }
            int ciphertextLength = inputLength - 16;
            byte[] tmp = new byte[64 + ciphertextLength];
            System.arraycopy(input, inputOffset, tmp, 64, ciphertextLength);
            this.runCipher(tmp);
            this.initMAC(tmp);
            this.updateMAC(this.additionalData, 0, this.additionalData.length);
            this.updateMAC(input, inputOffset, ciphertextLength);
            byte[] expectedMac = new byte[16];
            Pack.longToLittleEndian((long)this.additionalData.length & 0xFFFFFFFFL, expectedMac, 0);
            Pack.longToLittleEndian((long)ciphertextLength & 0xFFFFFFFFL, expectedMac, 8);
            this.mac.update(expectedMac, 0, 16);
            this.mac.doFinal(expectedMac, 0);
            boolean bl = badMac = !TlsUtils.constantTimeAreEqual(16, expectedMac, 0, input, inputOffset + ciphertextLength);
            if (badMac) {
                throw new TlsFatalAlert(20);
            }
            System.arraycopy(tmp, 64, output, outputOffset, ciphertextLength);
            return ciphertextLength;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public int getOutputSize(int inputLength) {
        return this.cipherMode == 1 ? inputLength + 16 : inputLength - 16;
    }

    public void init(byte[] nonce, int macSize, byte[] additionalData) throws IOException {
        if (nonce == null || nonce.length != 12 || macSize != 16) {
            throw new TlsFatalAlert(80);
        }
        try {
            this.cipher.init(this.cipherMode, (Key)this.cipherKey, new IvParameterSpec(nonce), null);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        this.additionalData = additionalData;
    }

    public void setKey(byte[] key, int keyOff, int keyLen) throws IOException {
        this.cipherKey = new SecretKeySpec(key, keyOff, keyLen, "ChaCha7539");
    }

    protected void initMAC(byte[] firstBlock) throws InvalidKeyException {
        this.mac.init(new SecretKeySpec(firstBlock, 0, 32, "Poly1305"));
        for (int i = 0; i < 64; ++i) {
            firstBlock[i] = 0;
        }
    }

    protected void runCipher(byte[] buf) throws GeneralSecurityException {
        int updateSize;
        int writeOff = 0;
        for (int readOff = 0; readOff < buf.length; readOff += updateSize) {
            updateSize = Math.min(32768, buf.length - readOff);
            writeOff += this.cipher.update(buf, readOff, updateSize, buf, writeOff);
        }
        if (buf.length != (writeOff += this.cipher.doFinal(buf, writeOff))) {
            throw new IllegalStateException();
        }
    }

    protected void updateMAC(byte[] buf, int off, int len) {
        this.mac.update(buf, off, len);
        int partial = len % 16;
        if (partial != 0) {
            this.mac.update(ZEROES, 0, 16 - partial);
        }
    }
}

