/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.jcajce;

import com.apusic.org.bouncycastle.tls.crypto.TlsHMAC;
import com.apusic.org.bouncycastle.util.Integers;
import java.security.InvalidKeyException;
import java.util.Hashtable;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class JceTlsHMAC
implements TlsHMAC {
    private static final Hashtable internalBlockSizes = new Hashtable();
    private final Mac hmac;
    private final String algorithm;
    private final Integer internalBlockSize;

    public JceTlsHMAC(Mac hmac, String algorithm) {
        this(hmac, algorithm, JceTlsHMAC.getInternalBlockSize(algorithm));
    }

    private static int getInternalBlockSize(String algorithm) {
        if (!internalBlockSizes.containsKey(algorithm)) {
            throw new IllegalArgumentException("HMAC " + algorithm + " unknown");
        }
        return (Integer)internalBlockSizes.get(algorithm);
    }

    public JceTlsHMAC(Mac hmac, String algorithm, int internalBlockSize) {
        this.hmac = hmac;
        this.algorithm = algorithm;
        this.internalBlockSize = Integers.valueOf(internalBlockSize);
    }

    public void setKey(byte[] key, int keyOff, int keyLen) {
        try {
            this.hmac.init(new SecretKeySpec(key, keyOff, keyLen, this.algorithm));
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void update(byte[] input, int inOff, int length) {
        this.hmac.update(input, inOff, length);
    }

    public byte[] calculateMAC() {
        return this.hmac.doFinal();
    }

    public void calculateMAC(byte[] output, int outOff) {
        try {
            this.hmac.doFinal(output, outOff);
        }
        catch (ShortBufferException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public int getInternalBlockSize() {
        return this.internalBlockSize;
    }

    public int getMacLength() {
        return this.hmac.getMacLength();
    }

    public void reset() {
        this.hmac.reset();
    }

    static {
        internalBlockSizes.put("HmacMD5", Integers.valueOf(64));
        internalBlockSizes.put("HmacSHA1", Integers.valueOf(64));
        internalBlockSizes.put("HmacSHA256", Integers.valueOf(64));
        internalBlockSizes.put("HmacSHA384", Integers.valueOf(128));
        internalBlockSizes.put("HmacSHA512", Integers.valueOf(128));
        internalBlockSizes.put("HmacSM3", Integers.valueOf(16));
    }
}

