/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.org.bouncycastle.tls.crypto.impl.jcajce;

import com.apusic.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.apusic.org.bouncycastle.tls.TlsFatalAlert;
import com.apusic.org.bouncycastle.tls.crypto.TlsAgreement;
import com.apusic.org.bouncycastle.tls.crypto.TlsCryptoException;
import com.apusic.org.bouncycastle.tls.crypto.TlsECDomain;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.JceX448;
import com.apusic.org.bouncycastle.tls.crypto.impl.jcajce.XDHUtil;
import com.apusic.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;

public class JceX448Domain
implements TlsECDomain {
    protected final JcaTlsCrypto crypto;

    public JceX448Domain(JcaTlsCrypto crypto) {
        this.crypto = crypto;
    }

    public JceTlsSecret calculateECDHAgreement(PrivateKey privateKey, PublicKey publicKey) throws IOException {
        try {
            byte[] secret = this.crypto.calculateKeyAgreement("X448", privateKey, publicKey, "TlsPremasterSecret");
            if (secret == null || secret.length != 56) {
                throw new TlsCryptoException("invalid secret calculated");
            }
            if (Arrays.areAllZeroes(secret, 0, secret.length)) {
                throw new TlsFatalAlert(40);
            }
            return this.crypto.adoptLocalSecret(secret);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot calculate secret", e);
        }
    }

    public TlsAgreement createECDH() {
        return new JceX448(this);
    }

    public PublicKey decodePublicKey(byte[] encoding) throws IOException {
        return XDHUtil.decodePublicKey(this.crypto, "X448", EdECObjectIdentifiers.id_X448, encoding);
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws IOException {
        return XDHUtil.encodePublicKey(publicKey);
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("X448");
            keyPairGenerator.initialize(448, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to create key pair: " + e.getMessage(), e);
        }
    }
}

