/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.utils;

import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorBigInt;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.utils.Reflector;
import com.googlecode.aviator.utils.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Properties;

public class Utils {
    private static final String CURRENT_VERSION = "5.0.0";
    private static final ThreadLocal<MessageDigest> MESSAGE_DIGEST_LOCAL = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("md5");
            }
            catch (Exception e) {
                throw Reflector.sneakyThrow(e);
            }
        }
    };
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private Utils() {
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String md5sum(String s) {
        MessageDigest md = MESSAGE_DIGEST_LOCAL.get();
        md.reset();
        byte[] messageDigest = md.digest(s.getBytes());
        return Utils.bytesToHex(messageDigest);
    }

    public static String readFully(Reader reader) throws IOException {
        int numChars;
        char[] arr = new char[16384];
        StringBuilder buf = new StringBuilder();
        while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
            buf.append(arr, 0, numChars);
        }
        return buf.toString();
    }

    public static AviatorNumber exponent(Number base, Number exp, Map<String, Object> env) {
        int expInt = exp.intValue();
        if (base instanceof BigInteger) {
            return new AviatorBigInt(((BigInteger)base).pow(expInt));
        }
        if (base instanceof BigDecimal) {
            return new AviatorDecimal(((BigDecimal)base).pow(expInt, RuntimeUtils.getMathContext(env)));
        }
        double ret = Math.pow(base.doubleValue(), exp.doubleValue());
        if (TypeUtils.isDouble(base) || TypeUtils.isDouble(exp) || exp.doubleValue() < 0.0) {
            return new AviatorDouble(ret);
        }
        return AviatorLong.valueOf((long)ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAviatorScriptVersion() {
        Properties prop = new Properties();
        InputStream in = null;
        try {
            in = Utils.class.getResourceAsStream("/META-INF/maven/com.googlecode.aviator/aviator/pom.properties");
            prop.load(in);
            String string = prop.getProperty("version", CURRENT_VERSION);
            return string;
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return CURRENT_VERSION;
    }

    public static boolean isAndroid() {
        try {
            Class.forName("android.os.Build");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

