/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiFormatReader
implements Reader {
    private Map<DecodeHintType, ?> hints;
    private Reader[] readers;

    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException {
        this.setHints(null);
        return this.decodeInternal(image);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        this.setHints(hints);
        return this.decodeInternal(image);
    }

    public Result decodeWithState(BinaryBitmap image) throws NotFoundException {
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal(image);
    }

    public void setHints(Map<DecodeHintType, ?> hints) {
        this.hints = hints;
        boolean tryHarder = hints != null && hints.containsKey((Object)DecodeHintType.TRY_HARDER);
        Collection formats = hints == null ? null : (Collection)hints.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<QRCodeReader> readers = new ArrayList<QRCodeReader>();
        if (formats != null) {
            boolean addOneDReader;
            boolean bl = addOneDReader = formats.contains((Object)BarcodeFormat.UPC_A) || formats.contains((Object)BarcodeFormat.UPC_E) || formats.contains((Object)BarcodeFormat.EAN_13) || formats.contains((Object)BarcodeFormat.EAN_8) || formats.contains((Object)BarcodeFormat.CODE_39) || formats.contains((Object)BarcodeFormat.CODE_93) || formats.contains((Object)BarcodeFormat.CODE_128) || formats.contains((Object)BarcodeFormat.ITF) || formats.contains((Object)BarcodeFormat.RSS_14) || formats.contains((Object)BarcodeFormat.RSS_EXPANDED);
            if (formats.contains((Object)BarcodeFormat.QR_CODE)) {
                readers.add(new QRCodeReader());
            }
        }
        if (readers.isEmpty()) {
            readers.add(new QRCodeReader());
        }
        this.readers = readers.toArray(new Reader[readers.size()]);
    }

    @Override
    public void reset() {
        if (this.readers != null) {
            Reader[] readerArray = this.readers;
            int n = this.readers.length;
            int n2 = 0;
            while (n2 < n) {
                Reader reader = readerArray[n2];
                reader.reset();
                ++n2;
            }
        }
    }

    private Result decodeInternal(BinaryBitmap image) throws NotFoundException {
        if (this.readers != null) {
            Reader[] readerArray = this.readers;
            int n = this.readers.length;
            int n2 = 0;
            while (n2 < n) {
                Reader reader = readerArray[n2];
                try {
                    return reader.decode(image, this.hints);
                }
                catch (ReaderException readerException) {
                    ++n2;
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

