/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.AlignmentPattern;
import java.util.ArrayList;
import java.util.List;

final class AlignmentPatternFinder {
    private final BitMatrix image;
    private final List<AlignmentPattern> possibleCenters;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private final float moduleSize;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    AlignmentPatternFinder(BitMatrix image, int startX, int startY, int width, int height, float moduleSize, ResultPointCallback resultPointCallback) {
        this.image = image;
        this.possibleCenters = new ArrayList<AlignmentPattern>(5);
        this.startX = startX;
        this.startY = startY;
        this.width = width;
        this.height = height;
        this.moduleSize = moduleSize;
        this.crossCheckStateCount = new int[3];
        this.resultPointCallback = resultPointCallback;
    }

    AlignmentPattern find() throws NotFoundException {
        int startX = this.startX;
        int height = this.height;
        int maxJ = startX + this.width;
        int middleI = this.startY + (height >> 1);
        int[] stateCount = new int[3];
        int iGen = 0;
        while (iGen < height) {
            AlignmentPattern confirmed;
            int i = middleI + ((iGen & 1) == 0 ? iGen + 1 >> 1 : -(iGen + 1 >> 1));
            stateCount[0] = 0;
            stateCount[1] = 0;
            stateCount[2] = 0;
            int j = startX;
            while (j < maxJ && !this.image.get(j, i)) {
                ++j;
            }
            int currentState = 0;
            while (j < maxJ) {
                if (this.image.get(j, i)) {
                    if (currentState == 1) {
                        int n = currentState;
                        stateCount[n] = stateCount[n] + 1;
                    } else if (currentState == 2) {
                        if (this.foundPatternCross(stateCount) && (confirmed = this.handlePossibleCenter(stateCount, i, j)) != null) {
                            return confirmed;
                        }
                        stateCount[0] = stateCount[2];
                        stateCount[1] = 1;
                        stateCount[2] = 0;
                        currentState = 1;
                    } else {
                        int n = ++currentState;
                        stateCount[n] = stateCount[n] + 1;
                    }
                } else {
                    if (currentState == 1) {
                        // empty if block
                    }
                    int n = ++currentState;
                    stateCount[n] = stateCount[n] + 1;
                }
                ++j;
            }
            if (this.foundPatternCross(stateCount) && (confirmed = this.handlePossibleCenter(stateCount, i, maxJ)) != null) {
                return confirmed;
            }
            ++iGen;
        }
        if (!this.possibleCenters.isEmpty()) {
            return this.possibleCenters.get(0);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static float centerFromEnd(int[] stateCount, int end) {
        return (float)(end - stateCount[2]) - (float)stateCount[1] / 2.0f;
    }

    private boolean foundPatternCross(int[] stateCount) {
        float moduleSize = this.moduleSize;
        float maxVariance = moduleSize / 2.0f;
        int i = 0;
        while (i < 3) {
            if (Math.abs(moduleSize - (float)stateCount[i]) >= maxVariance) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private float crossCheckVertical(int startI, int centerJ, int maxCount, int originalStateCountTotal) {
        image = this.image;
        maxI = image.getHeight();
        stateCount = this.crossCheckStateCount;
        stateCount[0] = 0;
        stateCount[1] = 0;
        stateCount[2] = 0;
        i = startI;
        while (i >= 0 && image.get(centerJ, i) && stateCount[1] <= maxCount) {
            stateCount[1] = stateCount[1] + 1;
            --i;
        }
        if (i >= 0 && stateCount[1] <= maxCount) ** GOTO lbl16
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[0] = stateCount[0] + 1;
            --i;
lbl16:
            // 2 sources

            ** while (i >= 0 && !image.get((int)centerJ, (int)i) && stateCount[0] <= maxCount)
        }
lbl17:
        // 1 sources

        if (stateCount[0] > maxCount) {
            return NaNf;
        }
        i = startI + 1;
        while (i < maxI && image.get(centerJ, i) && stateCount[1] <= maxCount) {
            stateCount[1] = stateCount[1] + 1;
            ++i;
        }
        if (i != maxI && stateCount[1] <= maxCount) ** GOTO lbl28
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[2] = stateCount[2] + 1;
            ++i;
lbl28:
            // 2 sources

            ** while (i < maxI && !image.get((int)centerJ, (int)i) && stateCount[2] <= maxCount)
        }
lbl29:
        // 1 sources

        if (stateCount[2] > maxCount) {
            return NaNf;
        }
        stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= 2 * originalStateCountTotal) {
            return NaNf;
        }
        return this.foundPatternCross(stateCount) != false ? AlignmentPatternFinder.centerFromEnd(stateCount, i) : NaNf;
    }

    private AlignmentPattern handlePossibleCenter(int[] stateCount, int i, int j) {
        int stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2];
        float centerJ = AlignmentPatternFinder.centerFromEnd(stateCount, j);
        float centerI = this.crossCheckVertical(i, (int)centerJ, 2 * stateCount[1], stateCountTotal);
        if (!Float.isNaN(centerI)) {
            float estimatedModuleSize = (float)(stateCount[0] + stateCount[1] + stateCount[2]) / 3.0f;
            for (AlignmentPattern center : this.possibleCenters) {
                if (!center.aboutEquals(estimatedModuleSize, centerI, centerJ)) continue;
                return center.combineEstimate(centerI, centerJ, estimatedModuleSize);
            }
            AlignmentPattern point = new AlignmentPattern(centerJ, centerI, estimatedModuleSize);
            this.possibleCenters.add(point);
            if (this.resultPointCallback != null) {
                this.resultPointCallback.foundPossibleResultPoint(point);
            }
        }
        return null;
    }
}

