/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.AlgoException;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.DoubleType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.algo.datatype.UnknownType;

public abstract class DataType
implements Serializable {
    private static final long serialVersionUID = 7577577815641844438L;
    public static final int BooleanTypeOrdinal = 0;
    public static final int StringTypeOrdinal = 1;
    public static final int IntegerTypeOrdinal = 2;
    public static final int LongTypeOrdinal = 3;
    public static final int DoubleTypeOrdinal = 4;
    public static final int BigDecimalTypeOrdinal = 5;
    public static final int DateTypeOrdinal = 6;
    public static final int TimestampTypeOrdinal = 7;
    public static final int NullTypeOrdinal = 8;
    public static final int UnknownTypeOrdinal = 9;
    public static final int AnyTypeOrdinal = 100;
    public static final int NumericTypeOrdinal = 200;
    public static BooleanType BooleanType = new BooleanType();
    public static StringType StringType = new StringType();
    public static IntegerType IntegerType = new IntegerType();
    public static LongType LongType = new LongType();
    public static DoubleType DoubleType = new DoubleType();
    public static BigDecimalType BigDecimalType = new BigDecimalType();
    public static DateType DateType = new DateType();
    public static TimestampType TimestampType = new TimestampType();
    public static NullType NullType = new NullType();
    public static UnknownType UnknownType = new UnknownType();
    protected final String name;
    public final int ordinal;

    public static BigDecimalType createBigDecimalType(int precision) {
        return BigDecimalType;
    }

    public static BigDecimalType createBigDecimalType(int precision, int scale) {
        return BigDecimalType;
    }

    protected DataType(int ordinal) {
        this(ordinal, null);
    }

    protected DataType(int ordinal, String name) {
        this.ordinal = ordinal;
        if (name == null) {
            name = this.getClass().getSimpleName();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSql() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int guessHeapSize(Object value) {
        return 0;
    }

    public abstract int getFixedSize();

    public abstract int getSqlType();

    public abstract Class<?> getJavaType();

    public abstract boolean acceptsType(DataType var1);

    public abstract void write(Object var1, DataOutputStream var2) throws IOException;

    public abstract Object read(DataInputStream var1) throws IOException;

    public Object convertValue(Object value) {
        return DataType.convertValue(this, value);
    }

    public static Object convertValue(DataType dataType, Object value) {
        if (value == null) {
            return null;
        }
        try {
            switch (dataType.ordinal) {
                case 5: {
                    if (value instanceof BigDecimal) {
                        return value;
                    }
                    if (value instanceof Long) {
                        return BigDecimal.valueOf((Long)value);
                    }
                    if (value instanceof Integer) {
                        return BigDecimal.valueOf(((Integer)value).intValue());
                    }
                    if (value instanceof Double) {
                        return BigDecimal.valueOf((Double)value);
                    }
                    return new BigDecimal(value.toString());
                }
                case 3: {
                    if (value instanceof Long) {
                        return (Long)value;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).longValue();
                    }
                    return Long.valueOf(value.toString());
                }
                case 1: {
                    if (value instanceof String) {
                        return (String)value;
                    }
                    return value.toString();
                }
                case 2: {
                    if (value instanceof Integer) {
                        return (Integer)value;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).intValue();
                    }
                    return Integer.valueOf(value.toString());
                }
                case 0: {
                    if (value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    if (value instanceof String) {
                        return Boolean.parseBoolean((String)value) || "1".equals(value);
                    }
                    if (value instanceof Number) {
                        return ((Number)value).doubleValue() != 0.0;
                    }
                    throw new AlgoException("Can't not convert value to Boolean: " + value);
                }
                case 6: {
                    if (value instanceof Date) {
                        return value;
                    }
                    if (value instanceof Calendar) {
                        return ((Calendar)value).getTime();
                    }
                    if (value instanceof String) {
                        Date date = DataType.toDate((String)value);
                        if (date == null) {
                            throw new AlgoException("Can't not convert value to Date:" + value);
                        }
                        return date;
                    }
                    throw new AlgoException("Can't not convert value to Date:" + value);
                }
                case 7: {
                    if (value instanceof Timestamp) {
                        return value;
                    }
                    if (value instanceof String) {
                        Date date = DataType.toDate((String)value);
                        if (date == null) {
                            throw new AlgoException("Can't not convert value to Timestamp:" + value);
                        }
                        return new Timestamp(date.getTime());
                    }
                    if (value instanceof Date) {
                        return new Timestamp(((Date)value).getTime());
                    }
                    if (value instanceof Calendar) {
                        return new Timestamp(((Calendar)value).getTimeInMillis());
                    }
                    throw new AlgoException("Can't not convert value to Timestamp:" + value);
                }
                case 4: {
                    if (value instanceof Double) {
                        return (Double)value;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).doubleValue();
                    }
                    return Double.valueOf(value.toString());
                }
                case 200: {
                    if (value instanceof Number) {
                        return value;
                    }
                    throw new AlgoException("Can't not convert value to Numeric:" + value);
                }
            }
            return value;
        }
        catch (Exception e) {
            throw new AlgoException("Can't cast %s to %s", value.toString(), dataType.name);
        }
    }

    private static SimpleDateFormat[] getDateFormats() {
        return new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd")};
    }

    private static Date toDate(String v) {
        if (v == null) {
            return null;
        }
        SimpleDateFormat[] dateFormats = DataType.getDateFormats();
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                return dateFormats[i].parse(v);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    public boolean isAbstract() {
        return false;
    }

    public static DataType fromSqlType(int sqlType) {
        switch (sqlType) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return StringType;
            }
            case -6: 
            case 4: 
            case 5: {
                return IntegerType;
            }
            case -5: {
                return LongType;
            }
            case 16: {
                return BooleanType;
            }
            case 6: 
            case 8: {
                return DoubleType;
            }
            case 2: 
            case 3: 
            case 7: {
                return BigDecimalType;
            }
            case 91: {
                return DateType;
            }
            case 93: {
                return TimestampType;
            }
            case 0: {
                return NullType;
            }
        }
        throw new AlgoException("Unsupported sqlType: " + sqlType);
    }

    public static int toSqlType(DataType dataType) {
        switch (dataType.ordinal) {
            case 0: {
                return 16;
            }
            case 1: {
                return 12;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return -5;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 91;
            }
            case 7: {
                return 93;
            }
        }
        throw new AlgoException("Not support dataType:" + dataType.getName());
    }

    public boolean equals(Object x) {
        return ((DataType)x).ordinal == this.ordinal;
    }
}

