/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.util.Collections;
import kd.bos.algo.AlgoException;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.env.Environment;
import kd.bos.algo.streamsource.StreamSource;

public class StreamSourceDataSet
extends AbstractDataSet {
    private StreamSource streamSource;

    public StreamSourceDataSet(Environment environment, StreamSource streamSource) {
        super(streamSource.getType(), environment, Collections.emptyList());
        this.streamSource = streamSource;
        this.rowMeta = this.createTargetRowMeta();
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.streamSource.getRowMeta();
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        try {
            return this.streamSource.rowIterator();
        }
        catch (AlgoException e) {
            throw new AlgoException("Can't iterator Dataset %s, because %s", this.toString(), e.getMessage());
        }
    }

    @Override
    public void realClose() {
        this.streamSource.close();
    }
}

