/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache;

import java.util.Iterator;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.DataSetCacheSpiFactory;

public class CachedDataSetImpl
implements CachedDataSet {
    DataSetCacheSpi spi;
    DataSetCacheMeta meta;
    private String id;
    private boolean closed;

    public CachedDataSetImpl(String id) {
        this.id = id;
        this.spi = DataSetCacheSpiFactory.getSpi();
        this.meta = this.spi.getMeta(id);
        if (this.meta == null) {
            throw new AlgoException("Cache dataset not found or timed out: " + id);
        }
    }

    public CachedDataSetImpl(String id, String storageType) {
        this.id = id;
        this.spi = DataSetCacheSpiFactory.getSpi(storageType);
        this.meta = this.spi.getMeta(id);
        if (this.meta == null) {
            throw new AlgoException("Cache dataset not found or timed out: " + id);
        }
    }

    public CachedDataSetImpl(DataSetCacheMeta meta) {
        this.spi = DataSetCacheSpiFactory.getSpi();
        this.meta = meta;
        this.id = meta.getId();
    }

    public CachedDataSetImpl(DataSetCacheSpi spi, DataSetCacheMeta meta) {
        this.spi = spi;
        this.meta = meta;
    }

    private void checkAvailable() {
        if (this.closed) {
            throw new AlgoException("cache dataset has been closed: " + this.id);
        }
    }

    @Override
    public int getRowCount() {
        this.checkAvailable();
        return this.meta.getRowCount();
    }

    @Override
    public Iterator<Row> iterator(int begin, int length) {
        this.checkAvailable();
        return this.spi.getIterator(this.meta, begin, length);
    }

    @Override
    public String getCacheId() {
        return this.id;
    }

    @Override
    public void close() {
        if (this.meta != null) {
            this.spi.delete(this.meta);
        }
        this.meta = null;
        this.closed = true;
    }

    @Override
    public RowMeta getRowMeta() {
        this.checkAvailable();
        return this.meta.getRowMeta();
    }

    @Override
    public List<Row> getList(int begin, int length) {
        this.checkAvailable();
        return this.spi.getList(this.meta, begin, length);
    }
}

