/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache;

import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.fs.FSSpiImpl;
import kd.bos.algo.dataset.cache.kv.KVSpiImpl;
import kd.bos.algo.storage.FileSystemStorage;
import kd.bos.algo.storage.KVStorage;
import kd.bos.algo.storage.StorageFactory;

public class DataSetCacheSpiFactory {
    public static DataSetCacheSpi getSpi() {
        String type = System.getProperty("algo.storage.datasetcache.type");
        return DataSetCacheSpiFactory.getSpi(type);
    }

    public static DataSetCacheSpi getSpi(String type) {
        if (type == null || "kv".equals(type) || "redis".equals(type)) {
            KVStorage storage = StorageFactory.getKVStorage();
            return new KVSpiImpl(storage);
        }
        if ("hbase".equals(type)) {
            KVStorage storage = StorageFactory.getKVHbaseStorage();
            return new KVSpiImpl(storage);
        }
        if ("local".equals(type)) {
            FileSystemStorage storage = StorageFactory.getLocalFileSystemStorage();
            return new FSSpiImpl(storage);
        }
        FileSystemStorage storage = StorageFactory.getFileSystemStorage();
        return new FSSpiImpl(storage);
    }
}

