/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.ArrayKey;

public abstract class GroupByOperator {
    protected Iterator<Row> iter;
    protected Aggregator[] aggregators;
    protected boolean[] descs;
    protected RowMeta targetRowMeta;
    protected Calc[] groupCalcs;
    protected Calc[] aggCalcs;

    public GroupByOperator(Iterator<Row> iter, Calc[] groupCalcs, boolean[] descs, Calc[] aggCalcs, Aggregator[] aggregators, RowMeta targetRowMeta) {
        this.iter = iter;
        this.groupCalcs = groupCalcs;
        this.descs = descs;
        this.aggCalcs = aggCalcs;
        this.aggregators = aggregators;
        this.targetRowMeta = targetRowMeta;
    }

    public abstract void build();

    public abstract void close();

    public abstract InnerRowIterator createIterator();

    protected Row makeTargetRow(ArrayKey groupKeys, Object[] aggValues) {
        Object[] values = new Object[groupKeys.length() + aggValues.length];
        System.arraycopy(groupKeys.getArray(), 0, values, 0, groupKeys.length());
        for (int i = 0; i < aggValues.length; ++i) {
            values[i + groupKeys.length()] = this.aggregators[i].getValue(aggValues[i]);
        }
        return RowFactory.createRow(this.targetRowMeta, values, false);
    }
}

