/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.ArrayKey;

public class GroupByRow
extends AbstractRow {
    private static final long serialVersionUID = -4905035354307827376L;
    private int size;
    private ArrayKey groupKeys;
    private Object[] aggValues;
    private Aggregator[] aggregators;
    private int keyLength;
    private RowMeta rowMeta;

    public GroupByRow(RowMeta rowMeta, ArrayKey groupKeys, Object[] aggValues, Aggregator[] aggregators) {
        this.rowMeta = rowMeta;
        this.size = rowMeta.getFieldCount();
        this.groupKeys = groupKeys;
        this.aggValues = aggValues;
        this.aggregators = aggregators;
        this.keyLength = groupKeys.length();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(int index) {
        if (index < this.keyLength) {
            return this.groupKeys.get(index);
        }
        return this.aggregators[index - this.keyLength].getValue(this.aggValues[index - this.keyLength]);
    }

    @Override
    public Object[] values() {
        Object[] values = new Object[this.size];
        System.arraycopy(this.groupKeys.getArray(), 0, values, 0, this.keyLength);
        for (int i = this.keyLength; i < this.size; ++i) {
            values[i] = this.aggregators[i - this.keyLength].getValue(this.aggValues[i - this.keyLength]);
        }
        return values;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

