/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.groupby.GroupbyInfo;
import kd.bos.algo.dataset.groupby.NullGroupsDataSet;
import kd.bos.algo.dataset.groupby.OrderBasedGroupByDataSet;
import kd.bos.algo.dataset.groupby.SingleGroupByDataSet;
import kd.bos.algo.dataset.groupby.SmartGroupByDataSet;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.sql.parser.SqlParser;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.Literal;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.UnaryExpr;
import kd.bos.algo.sql.tree.agg.AvgExpr;
import kd.bos.algo.sql.tree.agg.CountExpr;
import kd.bos.algo.sql.tree.agg.CustomizedAggExpr;
import kd.bos.algo.sql.tree.agg.MaxExpr;
import kd.bos.algo.sql.tree.agg.MaxPExpr;
import kd.bos.algo.sql.tree.agg.MinExpr;
import kd.bos.algo.sql.tree.agg.MinPExpr;
import kd.bos.algo.sql.tree.agg.SumExpr;

public class GroupbyDataSetBuilder
implements GroupbyDataSet {
    private AbstractDataSet innerDataSet;
    private GroupbyInfo info = new GroupbyInfo();
    SqlParser parser = new SqlParser();
    private boolean hasCompoundAgg;

    public GroupbyDataSetBuilder(AbstractDataSet innerDataSet, String[] groupFields) {
        this(innerDataSet, groupFields, null);
    }

    public GroupbyDataSetBuilder(AbstractDataSet innerDataSet, String[] groupFields, boolean[] orderByDescs) {
        this.innerDataSet = innerDataSet;
        if (groupFields != null && groupFields.length > 0) {
            for (String field : groupFields) {
                this.info.addGroup(field);
            }
        }
        this.info.setOrderByDescs(orderByDescs);
    }

    @Override
    public GroupbyDataSet sum(String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        UnaryExpr expr = new SumExpr(NodeLocation.FIRST_OPTIONAL, child);
        if (alias != null) {
            expr = new Alias(NodeLocation.FIRST_OPTIONAL, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        return this;
    }

    @Override
    public GroupbyDataSet avg(String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        UnaryExpr expr = new AvgExpr(NodeLocation.FIRST_OPTIONAL, child);
        if (alias != null) {
            expr = new Alias(NodeLocation.FIRST_OPTIONAL, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        this.hasCompoundAgg = true;
        return this;
    }

    @Override
    public GroupbyDataSet max(String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        UnaryExpr expr = new MaxExpr(NodeLocation.FIRST_OPTIONAL, child);
        if (alias != null) {
            expr = new Alias(NodeLocation.FIRST_OPTIONAL, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        return this;
    }

    public GroupbyDataSet agg(CustomAggFunction aggFunc, String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        UnaryExpr expr = new CustomizedAggExpr(NodeLocation.FIRST_OPTIONAL, aggFunc, child);
        if (alias != null) {
            expr = new Alias(NodeLocation.FIRST_OPTIONAL, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        return this;
    }

    @Override
    public GroupbyDataSet min(String field, String alias) {
        Expr child = this.parser.parseExpr(field);
        UnaryExpr expr = new MinExpr(NodeLocation.FIRST_OPTIONAL, child);
        if (alias != null) {
            expr = new Alias(NodeLocation.FIRST_OPTIONAL, (Expr)expr, alias);
        }
        this.info.addAgg(expr);
        return this;
    }

    @Override
    public GroupbyDataSet maxP(String expr, String propertyExpr, String alias) {
        Expr ex = this.parser.parseExpr(expr);
        Expr pex = this.parser.parseExpr(propertyExpr);
        ex = new MaxPExpr(NodeLocation.FIRST_OPTIONAL, ex, pex);
        if (alias != null) {
            ex = new Alias(NodeLocation.FIRST_OPTIONAL, ex, alias);
        }
        this.info.addAgg(ex);
        this.hasCompoundAgg = true;
        return this;
    }

    @Override
    public GroupbyDataSet minP(String expr, String propertyExpr, String alias) {
        Expr ex = this.parser.parseExpr(expr);
        Expr pex = this.parser.parseExpr(propertyExpr);
        ex = new MinPExpr(NodeLocation.FIRST_OPTIONAL, ex, pex);
        if (alias != null) {
            ex = new Alias(NodeLocation.FIRST_OPTIONAL, ex, alias);
        }
        this.info.addAgg(ex);
        this.hasCompoundAgg = true;
        return this;
    }

    @Override
    public GroupbyDataSet count(String alias) {
        Literal child = new Literal(NodeLocation.FIRST_OPTIONAL, 1, (DataType)DataType.IntegerType);
        UnaryExpr expr = new CountExpr(NodeLocation.FIRST_OPTIONAL, child);
        if (alias == null) {
            alias = "count";
        }
        expr = new Alias(NodeLocation.FIRST_OPTIONAL, (Expr)expr, alias);
        this.info.addAgg(expr);
        return this;
    }

    @Override
    public DataSet finish() {
        if (this.info.getGroups() == null) {
            return new SingleGroupByDataSet(this.innerDataSet, this.info);
        }
        if (this.groupIsAllNulls()) {
            return new NullGroupsDataSet(this.innerDataSet, this.info);
        }
        if (this.hasCompoundAgg) {
            return new OrderBasedGroupByDataSet(this.innerDataSet, this.info);
        }
        return new SmartGroupByDataSet(this.innerDataSet, this.info);
    }

    private boolean groupIsAllNulls() {
        String[] orderKeys = this.info.getGroups();
        RowMeta rowMeta = this.innerDataSet.getRowMeta();
        for (int i = 0; i < orderKeys.length; ++i) {
            DataType dataType = rowMeta.getField(orderKeys[i]).getDataType();
            if (dataType instanceof NullType) continue;
            return false;
        }
        return true;
    }

    @Override
    public GroupbyDataSet sum(String field) {
        return this.sum(field, null);
    }

    @Override
    public GroupbyDataSet avg(String field) {
        return this.avg(field, null);
    }

    @Override
    public GroupbyDataSet max(String field) {
        return this.max(field, null);
    }

    @Override
    public GroupbyDataSet min(String field) {
        return this.min(field, null);
    }

    @Override
    public GroupbyDataSet maxP(String field, String propertyField) {
        return this.maxP(field, propertyField, null);
    }

    @Override
    public GroupbyDataSet minP(String field, String propertyField) {
        return this.minP(field, propertyField, null);
    }

    @Override
    public GroupbyDataSet count() {
        return this.count(null);
    }
}

