/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.hashjoin;

import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.HashTable;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;

public class MemHashTable
implements HashTable {
    private RowMeta rowMeta;
    private HashMap<Object, Row> map = new HashMap();
    private int keyIndex;

    public MemHashTable(DataSet dataSet, int keyIndex) {
        this.keyIndex = keyIndex;
        this.rowMeta = dataSet.getRowMeta();
        this.build(dataSet);
    }

    private void build(DataSet dataSet) {
        for (Row row : dataSet) {
            this.map.putIfAbsent(row.get(this.keyIndex), ((AbstractRow)row).persist());
        }
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public Row lookup(Object key) {
        return this.map.get(key);
    }

    @Override
    public void close() {
    }
}

