/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.input;

import java.util.Collections;
import kd.bos.algo.Input;
import kd.bos.algo.InputExecutor;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.input.BatchInputExecutorsRowIterator;
import kd.bos.algo.dataset.input.InputExecutorFactory;
import kd.bos.algo.dataset.input.InputExecutorRowIterator;
import kd.bos.algo.env.Environment;
import kd.bos.algo.env.jvm.JvmEnvironment;

public class InputDataSet
extends AbstractDataSet {
    private Input[] inputs;
    private InputExecutor[] executors;
    private BatchInputExecutorsRowIterator batch;

    public InputDataSet(JvmEnvironment env, Input[] inputs) {
        super("Input", (Environment)env, Collections.emptyList());
        this.inputs = inputs;
        this.executors = new InputExecutor[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            this.executors[i] = InputExecutorFactory.create(inputs[i]);
        }
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        return this.inputs[0].getRowMeta();
    }

    @Override
    protected InnerRowIterator createIterator() {
        if (this.executors.length == 1) {
            return this.createIterator(this.executors[0]);
        }
        return this.createIterators(this.executors);
    }

    private InnerRowIterator createIterators(InputExecutor[] executors) {
        this.batch = new BatchInputExecutorsRowIterator(executors);
        return this.batch;
    }

    private InnerRowIterator createIterator(InputExecutor inputExecutor) {
        return new InputExecutorRowIterator(inputExecutor);
    }

    @Override
    public void realClose() {
        for (InputExecutor executor : this.executors) {
            executor.close();
        }
        if (this.batch != null) {
            this.batch.close();
        }
    }
}

