/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.dataset.join.HHJMemory;
import kd.bos.algo.dataset.store.spill.MemIO;
import kd.bos.algo.dataset.store.spill.MemIOFactory;
import org.apache.flink.runtime.memory.MemoryAllocationException;

public class HHJMemCache {
    private static int MAXITEMS = 2;
    private List<HHJMemory> list = new ArrayList<HHJMemory>(2);

    public synchronized HHJMemory acquire() {
        if (this.list.isEmpty()) {
            return this.create();
        }
        return this.list.remove(0);
    }

    private HHJMemory create() {
        MemIO memIO = MemIOFactory.createForJoin();
        try {
            List segments = memIO.getMemoryManager().allocatePages((Object)memIO.getParentTask(), memIO.getMemoryManager().getTotalNumPages());
            return new HHJMemory(segments, memIO.getIoManager());
        }
        catch (MemoryAllocationException e) {
            throw new AlgoException(e);
        }
    }

    public synchronized void recycle(HHJMemory m) {
        if (this.list.size() < MAXITEMS) {
            m.reset();
            this.list.add(m);
        }
    }
}

