/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import kd.bos.algo.JoinHint;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.join.InnerMergeJoinResult;
import kd.bos.algo.dataset.join.InnerNestJoinResult;
import kd.bos.algo.dataset.join.JoinDataSet;
import kd.bos.algo.dataset.join.JoinDataSetBuilder;
import kd.bos.algo.dataset.join.JoinPolicy;
import kd.bos.algo.dataset.store.Store;

public class InnerJoinDataSet
extends JoinDataSet {
    private JoinHint joinHint;

    public InnerJoinDataSet(AbstractDataSet leftDataSet, AbstractDataSet rightDataSet, JoinDataSetBuilder builder) {
        super("InnerJoin", leftDataSet, rightDataSet, builder);
        this.joinHint = builder.getJoinHint();
    }

    @Override
    protected InnerRowIterator createIterator() {
        int rightSize;
        this.checkClosed();
        AbstractDataSet leftDataSet = this.getLeftDataSet();
        AbstractDataSet rightDataSet = this.getRightDataSet();
        if (this.joinHint.isUseMerge()) {
            return new InnerMergeJoinResult(leftDataSet.innerIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightDataSet.innerIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getSpanTag());
        }
        Store leftStore = leftDataSet.getStore();
        Store rightStore = rightDataSet.getStore();
        if (leftStore != null && rightStore != null) {
            int rightSize2;
            int leftSize = leftStore.size();
            if (leftSize >= (rightSize2 = rightStore.size())) {
                if (this.joinHint.isUseNest() || rightSize2 <= JoinPolicy.getThreshold()) {
                    return new InnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow);
                }
                return new InnerMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getSpanTag());
            }
            if (this.joinHint.isUseNest() || leftSize <= JoinPolicy.getThreshold()) {
                return new InnerNestJoinResult(rightStore.getRowIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX);
            }
            return new InnerMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getSpanTag());
        }
        if (leftStore != null) {
            int leftSize = leftStore.size();
            if (leftSize <= JoinPolicy.getThreshold()) {
                return new InnerNestJoinResult(rightDataSet.innerIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX);
            }
            rightDataSet.ensureStore();
            rightStore = rightDataSet.getStore();
            int rightSize3 = rightStore.size();
            if (rightSize3 <= JoinPolicy.getThreshold()) {
                return new InnerNestJoinResult(leftStore.getRowIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow);
            }
            if (leftSize > rightSize3) {
                return new InnerMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getSpanTag());
            }
            return new InnerMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getSpanTag());
        }
        if (rightStore == null) {
            rightDataSet.ensureStore();
            rightStore = rightDataSet.getStore();
        }
        if ((rightSize = rightStore.size()) <= JoinPolicy.getThreshold()) {
            return new InnerNestJoinResult(leftDataSet.innerIterator(), this.getLeftJoinOnColumns(), rightStore, rightDataSet.getRowMeta(), this.getRightJoinOnColumns(), this::makeTargetRow);
        }
        leftDataSet.ensureStore();
        leftStore = leftDataSet.getStore();
        int leftSize = leftStore.size();
        if (leftSize <= JoinPolicy.getThreshold()) {
            return new InnerNestJoinResult(rightStore.getRowIterator(), this.getRightJoinOnColumns(), leftStore, leftDataSet.getRowMeta(), this.getLeftJoinOnColumns(), this::makeTargetRowX);
        }
        if (leftSize > rightSize) {
            return new InnerMergeJoinResult(leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), this::makeTargetRow, this.getSpanTag());
        }
        return new InnerMergeJoinResult(rightStore.getRowIterator(), rightDataSet.getRowMeta(), this.getRightOrderItems(), this.getRightJoinOnColumns(), leftStore.getRowIterator(), leftDataSet.getRowMeta(), this.getLeftOrderItems(), this.getLeftJoinOnColumns(), this::makeTargetRowX, this.getSpanTag());
    }
}

