/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.range;

import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;

public class RangeDataSet
extends AbstractDataSet {
    private int start;
    private int length;

    public RangeDataSet(AbstractDataSet dataSet, int start, int length) {
        this("Limit", dataSet, start, length);
    }

    protected RangeDataSet(String name, AbstractDataSet dataSet, int start, int length) {
        super(name, dataSet);
        this.start = start;
        if (start < 0) {
            start = 0;
        }
        this.length = length;
        if (length < 0) {
            throw new AlgoException("Illegal length %d", length);
        }
        this.rowMeta = this.createTargetRowMeta();
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        if (this.length == 0) {
            return InnerRowIterator.EMPTY;
        }
        AbstractDataSet inner = this.getInput(0);
        final InnerRowIterator iter = inner.innerIterator();
        int index = 0;
        while (index++ < this.start) {
            if (!iter.hasNext()) continue;
            iter.next();
        }
        return new InnerRowIterator(){
            int index = 0;

            @Override
            public boolean _hasNext() {
                return this.index < RangeDataSet.this.length && iter.hasNext();
            }

            @Override
            public Row _next() {
                Row result = (Row)iter.next();
                ++this.index;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.getInput(0).getRowMeta();
    }

    @Override
    public void realClose() {
    }
}

