/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.schema;

import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.sql.schema.Column;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.schema.Table;

public class CommonColumn
implements Column {
    private Table table;
    private int index;
    private DataType dataType;
    private String name;

    public CommonColumn(Table table, Field field, int index) {
        this(table, field.getAlias(), field.getDataType(), index);
    }

    public CommonColumn(Table table, String name, DataType dataType, int index) {
        this.table = table;
        this.name = name;
        this.dataType = dataType;
        this.index = index;
    }

    @Override
    public Schema getSchema() {
        return this.table.getSchema();
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        if ("default".equals(this.table.getName())) {
            return this.getName();
        }
        return this.table.getName() + "." + this.getName();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }
}

