/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.schema;

import java.util.LinkedHashMap;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.schema.CommonColumn;
import kd.bos.algo.sql.schema.Column;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.schema.Table;

public class DataSetTable
implements Table {
    private RowMeta meta;
    private String name;
    private LinkedHashMap<String, CommonColumn> map = new LinkedHashMap();
    private Schema schema;

    public DataSetTable(Schema schema, RowMeta meta, String name) {
        this.meta = meta;
        this.name = name;
        this.schema = schema;
        this.initColumns();
    }

    private void initColumns() {
        for (int i = 0; i < this.meta.getFields().length; ++i) {
            Field field = this.meta.getField(i);
            this.add(field, new CommonColumn(this, field, i));
        }
    }

    private String makeKey(String key) {
        return this.schema.isIgnoreCase() ? key.toUpperCase() : key;
    }

    private void add(Field field, CommonColumn dataSetColumn) {
        this.map.put(this.makeKey(field.getAlias()), dataSetColumn);
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Column[] getColumns() {
        return this.map.values().toArray(new Column[0]);
    }

    @Override
    public Column lookupColumn(String name) {
        return this.map.get(this.makeKey(name));
    }
}

