/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store;

import java.util.ArrayList;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreWrapper;
import kd.bos.algo.dataset.store.impl.SequenceStore;
import kd.bos.algo.dataset.store.impl.TashaOrderStore;
import kd.bos.algo.datatype.NullType;

public class StoreFactory {
    public static Store createSequenceStore(RowMeta rowMeta) {
        return new StoreWrapper(new SequenceStore(rowMeta));
    }

    public static Store createOrderStore(RowMeta rowMeta, OrderItem[] orderItems) {
        ArrayList<OrderItem> notNullOrderItems = new ArrayList<OrderItem>();
        for (int i = 0; i < orderItems.length; ++i) {
            DataType dataType = rowMeta.getField(orderItems[i].expr).getDataType();
            if (dataType instanceof NullType) continue;
            notNullOrderItems.add(orderItems[i]);
        }
        if (notNullOrderItems.size() > 0) {
            orderItems = notNullOrderItems.toArray(new OrderItem[notNullOrderItems.size()]);
            return new StoreWrapper(new TashaOrderStore(rowMeta, orderItems));
        }
        return new StoreWrapper(new SequenceStore(rowMeta));
    }
}

