/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.heap;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.store.heap.HeapLimitPolicy;

public class GlobalMaxRowsLimitPolicy
implements HeapLimitPolicy {
    private AtomicInteger count = new AtomicInteger(0);
    private int limit;

    public GlobalMaxRowsLimitPolicy(int limit) {
        this.limit = limit;
    }

    @Override
    public boolean canAddRow(Row row) {
        if (this.count.get() < this.limit) {
            this.count.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public void releaseRowCount(final int rowCount) {
        this.count.updateAndGet(new IntUnaryOperator(){

            @Override
            public int applyAsInt(int operand) {
                return operand - rowCount;
            }
        });
    }

    public synchronized void setMaxRowsLimit(int limit) {
        this.limit = limit;
    }
}

