/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.heap;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.heap.HeapLimitPolicy;

public abstract class HeapStore {
    private HeapLimitPolicy limitPolicy;

    public HeapStore(HeapLimitPolicy limitPolicy) {
        this.limitPolicy = limitPolicy;
    }

    public abstract void addRow(Row var1);

    public abstract Iterator<Row> getResultIterator();

    public abstract Iterator<Row> getOriginalIterator();

    public abstract int getRowCount();

    public abstract Store toStore(RowMeta var1);

    public void close() {
        int count = this.getRowCount();
        if (count > 0) {
            this.limitPolicy.releaseRowCount(count);
        }
    }

    public Row writeIterator(Iterator<Row> iter) {
        while (iter.hasNext()) {
            Row row = iter.next();
            if (this.write(row)) continue;
            return row;
        }
        return null;
    }

    public boolean write(Row row) {
        if (!this.limitPolicy.canAddRow(row)) {
            return false;
        }
        this.addRow(row);
        return true;
    }
}

