/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.impl;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.store.CopyFeature;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.heap.HeapStore;
import kd.bos.algo.dataset.store.heap.HeapStoreFactory;
import kd.bos.algo.dataset.store.impl.RowConvert;
import kd.bos.algo.dataset.store.sort.UnilateralSortMerger;
import kd.bos.algo.dataset.store.spill.DummyInvokable;
import kd.bos.algo.dataset.store.spill.MemIO;
import kd.bos.algo.dataset.store.spill.MemIOFactory;
import kd.bos.algo.dataset.store.spill.RowXSerializerFactory;
import kd.bos.algo.env.ThreadContext;
import kd.bos.algox.RowX;
import kd.bos.algox.flink.type.RowXTypeInfo;
import kd.bos.algox.flink.type.TypeUtil;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.util.MutableObjectIterator;

public class OrderStore
implements Store,
CopyFeature {
    private final RowMeta rowMeta;
    private final AbstractInvokable parentTask = new DummyInvokable();
    private MemIO memIO;
    private IOManager ioManager;
    private MemoryManager memoryManager;
    private RowXSerializerFactory pactRecordSerializer;
    private TypeComparator<RowX> pactRecordComparator;
    private HeapStore heapStore;
    private UnilateralSortMerger<RowX> merger;
    private boolean closed;
    private int[] orderIndexes;
    private boolean[] descs;
    private boolean hasWriteIter = false;

    public OrderStore(RowMeta rowMeta, OrderItem[] orderItems) {
        ThreadContext.getCurrent().addStore(this);
        this.rowMeta = rowMeta;
        this.orderIndexes = new int[orderItems.length];
        boolean[] ascs = new boolean[orderItems.length];
        this.descs = new boolean[orderItems.length];
        for (int i = 0; i < orderItems.length; ++i) {
            this.orderIndexes[i] = rowMeta.getFieldIndex(orderItems[i].expr);
            ascs[i] = orderItems[i].asc;
            this.descs[i] = !ascs[i];
        }
        RowXTypeInfo typeInfo = TypeUtil.toRowXType(rowMeta);
        this.pactRecordSerializer = new RowXSerializerFactory(typeInfo.createSerializer(rowMeta));
        this.pactRecordComparator = typeInfo.createComparator(this.orderIndexes, ascs, 0, null);
        this.heapStore = HeapStoreFactory.createHeapOrderStore(this.orderIndexes, this.descs);
    }

    @Override
    public Iterator<Row> getRowIterator() {
        if (this.merger == null) {
            return this.heapStore.getResultIterator();
        }
        try {
            return RowConvert.toRowIterator(this.rowMeta, this.merger.getIterator());
        }
        catch (InterruptedException e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public void write(Iterator<Row> iter) {
        if (this.hasWriteIter) {
            throw new AlgoException("Can't add Iterator twice");
        }
        this.hasWriteIter = true;
        Row failedRow = this.heapStore.writeIterator(iter);
        if (failedRow != null) {
            if (this.heapStore.getRowCount() > 0) {
                Iterator<Row> originIter = this.heapStore.getOriginalIterator();
                iter = Iterators.concat(originIter, (Iterator)Iterators.singletonIterator((Object)failedRow), (Iterator)iter);
            } else {
                iter = Iterators.concat((Iterator)Iterators.singletonIterator((Object)failedRow), iter);
            }
            this.writeX(this.rowMeta, iter);
        }
    }

    public void writeX(RowMeta rowMeta, Iterator<Row> iter) {
        this.memIO = MemIOFactory.createForSort();
        this.ioManager = this.memIO.getIoManager();
        this.memoryManager = this.memIO.getMemoryManager();
        MutableObjectIterator<RowX> source = RowConvert.toMutableRowXIterator(rowMeta, iter);
        try {
            this.merger = new UnilateralSortMerger<RowX>(this.memoryManager, this.ioManager, source, this.parentTask, this.pactRecordSerializer, this.pactRecordComparator, 1.0, 32, 1.0f, false, false);
        }
        catch (Exception e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public Store copy() {
        if (this.isCopyable()) {
            return this.heapStore.toStore(this.rowMeta);
        }
        return null;
    }

    @Override
    public void close() {
        if (!this.closed) {
            ThreadContext.getCurrent().removeStore(this);
            if (this.heapStore != null) {
                this.heapStore.close();
            }
            if (this.merger != null) {
                this.merger.close();
            }
            if (this.memIO != null) {
                this.memIO.close();
            }
            this.closed = true;
        }
    }

    @Override
    public boolean isCopyable() {
        return this.merger == null;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void write(Row row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.merger == null) {
            return this.heapStore.getRowCount();
        }
        return this.heapStore.getRowCount() + this.merger.getRowCount();
    }
}

