/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.store.RowXAsRow;
import kd.bos.algox.RowX;
import org.apache.flink.util.MutableObjectIterator;

public class RowConvert {
    public static Row toRow(RowMeta rowMeta, RowX rowX) {
        if (rowX == null) {
            return null;
        }
        return new RowXAsRow(rowMeta, rowX);
    }

    public static RowX toRowX(RowMeta rowMeta, Row row) {
        if (row == null) {
            return null;
        }
        if (row instanceof RowXAsRow) {
            return ((RowXAsRow)row).getRowX();
        }
        Object[] values = ((AbstractRow)row).values();
        RowFactory.convert(rowMeta, values);
        return new RowX(values);
    }

    public static Iterable<Row> toRowIterable(final RowMeta rowMeta, final Iterable<RowX> able) {
        return new Iterable<Row>(){

            @Override
            public Iterator<Row> iterator() {
                return RowConvert.toRowIterator(rowMeta, able.iterator());
            }
        };
    }

    public static Iterator<Row> toRowIterator(final RowMeta rowMeta, final Iterator<RowX> iter) {
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Row next() {
                return RowConvert.toRow(rowMeta, (RowX)iter.next());
            }
        };
    }

    public static Iterator<RowX> toRowXIterator(final RowMeta rowMeta, final Iterator<Row> iter) {
        return new Iterator<RowX>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public RowX next() {
                return RowConvert.toRowX(rowMeta, (Row)iter.next());
            }
        };
    }

    public static MutableObjectIterator<RowX> toMutableRowXIterator(final RowMeta rowMeta, final Iterator<Row> iter) {
        return new MutableObjectIterator<RowX>(){

            public RowX next(RowX r) throws IOException {
                return this.next();
            }

            public RowX next() throws IOException {
                if (iter.hasNext()) {
                    return RowConvert.toRowX(rowMeta, (Row)iter.next());
                }
                return null;
            }
        };
    }

    public static Iterator<Row> toRowIterator(final RowMeta rowMeta, final MutableObjectIterator<RowX> iter) {
        return new Iterator<Row>(){
            private boolean eof;
            private RowX next;

            @Override
            public boolean hasNext() {
                if (this.eof) {
                    return false;
                }
                if (this.next != null) {
                    return true;
                }
                return this.doNext();
            }

            private boolean doNext() {
                try {
                    this.next = (RowX)iter.next();
                }
                catch (IOException e) {
                    throw new AlgoException(e);
                }
                if (this.next == null) {
                    this.eof = true;
                    return false;
                }
                return true;
            }

            @Override
            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Row ret = RowConvert.toRow(rowMeta, this.next);
                this.next = null;
                return ret;
            }
        };
    }
}

