/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.impl;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.CopyFeature;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.heap.HeapStore;
import kd.bos.algo.dataset.store.heap.HeapStoreFactory;
import kd.bos.algo.dataset.store.impl.RowConvert;
import kd.bos.algo.dataset.store.spill.DummyInvokable;
import kd.bos.algo.dataset.store.spill.MemIO;
import kd.bos.algo.dataset.store.spill.MemIOFactory;
import kd.bos.algo.dataset.store.spill.SpillingWriter;
import kd.bos.algo.util.resource.Resource;

public class StandaloneSequenceStore
extends Resource
implements Store,
CopyFeature {
    private static final long serialVersionUID = -566664619098919394L;
    private RowMeta rowMeta;
    private MemIO memIO;
    HeapStore heapStore;
    SpillingWriter spill;

    public StandaloneSequenceStore(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.heapStore = HeapStoreFactory.createHeapSequenceStore();
        this.refer();
    }

    @Override
    public Iterator<Row> getRowIterator() {
        if (this.spill == null) {
            return this.heapStore.getResultIterator();
        }
        if (this.heapStore.getRowCount() > 0) {
            return Iterators.concat(this.heapStore.getResultIterator(), RowConvert.toRowIterator(this.rowMeta, this.spill.iterator()));
        }
        return RowConvert.toRowIterator(this.rowMeta, this.spill.iterator());
    }

    @Override
    public void write(Iterator<Row> iter) {
        if (this.spill != null) {
            this.spill.writeRowIter(iter);
            return;
        }
        Row failedRow = this.heapStore.writeIterator(iter);
        if (failedRow != null) {
            iter = Iterators.concat((Iterator)Iterators.singletonIterator((Object)failedRow), iter);
            this.writeX(iter);
        }
    }

    private void createSpill() {
        if (this.spill == null) {
            this.memIO = MemIOFactory.createForSpillBuffer();
            this.spill = new SpillingWriter(this.rowMeta, this.memIO.getMemoryManager(), this.memIO.getIoManager(), this.memIO.getMemoryManager().getTotalNumPages(), new DummyInvokable());
        }
    }

    public void writeX(Iterator<Row> iter) {
        this.createSpill();
        this.spill.writeRowIter(iter);
    }

    @Override
    public Store copy() {
        throw new AlgoException("Not supported");
    }

    @Override
    public void checkClosed() {
        if (this.closed) {
            throw new AlgoException("SequenceStore has been closed.");
        }
    }

    @Override
    public void realClose() {
        this.closed = true;
        if (this.heapStore != null) {
            this.heapStore.close();
        }
        if (this.spill != null) {
            this.spill.close();
        }
    }

    @Override
    public boolean isCopyable() {
        return true;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void write(Row row) {
        if (this.spill != null) {
            this.spill.writeRow(row);
            return;
        }
        if (!this.heapStore.write(row)) {
            this.createSpill();
            this.spill.writeRow(row);
        }
    }

    @Override
    public int size() {
        if (this.spill == null) {
            return this.heapStore.getRowCount();
        }
        return this.heapStore.getRowCount() + this.spill.size();
    }
}

