/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.impl;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AutoCloseIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.store.CopyFeature;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.heap.HeapStore;
import kd.bos.algo.dataset.store.heap.HeapStoreFactory;
import kd.bos.algo.dataset.store.sort.TashaSortMerger;
import kd.bos.algo.env.ThreadContext;
import kd.bos.algo.util.ConfigUtil;
import kd.bos.algo.util.resource.Resource;

public class TashaOrderStore
extends Resource
implements Store,
CopyFeature {
    private static final String BUFFER_SIZE = "algo.sort.sortmerge.buffer.size";
    private static final String BUFFER_NUM = "algo.sort.sortmerge.buffer.number";
    private static final int default_buffer_size = 100000;
    private static final int default_buffer_num = 3;
    private final RowMeta rowMeta;
    private HeapStore heapStore;
    private TashaSortMerger merger;
    private boolean closed;
    private int[] orderIndexes;
    private boolean[] descs;

    private static final int getBufferSize() {
        return ConfigUtil.getInteger(BUFFER_SIZE, 100000);
    }

    private static final int getBufferNum() {
        return ConfigUtil.getInteger(BUFFER_NUM, 3);
    }

    public TashaOrderStore(RowMeta rowMeta, OrderItem[] orderItems) {
        ThreadContext.getCurrent().addStore(this);
        this.rowMeta = rowMeta;
        this.orderIndexes = new int[orderItems.length];
        boolean[] ascs = new boolean[orderItems.length];
        this.descs = new boolean[orderItems.length];
        for (int i = 0; i < orderItems.length; ++i) {
            this.orderIndexes[i] = rowMeta.getFieldIndex(orderItems[i].expr);
            ascs[i] = orderItems[i].asc;
            this.descs[i] = !ascs[i];
        }
        this.heapStore = HeapStoreFactory.createHeapOrderStore(this.orderIndexes, this.descs);
        this.refer();
    }

    @Override
    public Iterator<Row> getRowIterator() {
        this.checkClosed();
        if (this.merger == null) {
            return this.heapStore.getResultIterator();
        }
        try {
            this.merger.writeEof();
            AutoCloseIterator iter = this.merger.getIterator();
            iter = new AutoCloseIterator(this, iter);
            return iter;
        }
        catch (InterruptedException e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public void write(Iterator<Row> iter) {
        if (this.merger != null) {
            this.merger.writeInput(iter);
            return;
        }
        Row failedRow = this.heapStore.writeIterator(iter);
        if (failedRow != null) {
            if (this.heapStore.getRowCount() > 0) {
                Iterator<Row> originIter = this.heapStore.getOriginalIterator();
                iter = Iterators.concat(originIter, (Iterator)Iterators.singletonIterator((Object)failedRow), (Iterator)iter);
                this.heapStore.close();
            } else {
                iter = Iterators.concat((Iterator)Iterators.singletonIterator((Object)failedRow), iter);
            }
            this.writeX(this.rowMeta, iter);
        }
    }

    private void writeX(RowMeta rowMeta, Iterator<Row> iter) {
        try {
            this.merger = new TashaSortMerger(rowMeta, this.orderIndexes, this.descs, TashaOrderStore.getBufferNum(), TashaOrderStore.getBufferSize());
            this.merger.writeInput(iter);
        }
        catch (Exception e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public Store copy() {
        this.checkClosed();
        this.refer();
        return this;
    }

    @Override
    public void checkClosed() {
        if (this.closed) {
            throw new AlgoException("OrderStore has been closed.");
        }
    }

    @Override
    public void realClose() {
        if (!this.closed) {
            ThreadContext.getCurrent().removeStore(this);
            this.closed = true;
            if (this.heapStore != null) {
                this.heapStore.close();
            }
            if (this.merger != null) {
                this.merger.close();
            }
        }
    }

    @Override
    public boolean isCopyable() {
        return this.merger == null;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void write(Row row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.checkClosed();
        if (this.merger == null) {
            return this.heapStore.getRowCount();
        }
        return this.merger.getRowCount();
    }
}

