/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.sort;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.store.ListStore;
import kd.bos.algo.dataset.store.Store;

public class TashaSortBuffer
implements Iterable<Row> {
    private ArrayList<Row> list = new ArrayList();
    private boolean sorted;
    private int maxSize;
    private Comparator<Row> comparator;

    public TashaSortBuffer(Comparator<Row> comparator, int maxSize) {
        this.comparator = comparator;
        this.maxSize = maxSize;
    }

    public boolean addRow(Row row) {
        if (this.list.size() < this.maxSize) {
            this.list.add(((AbstractRow)row).persist());
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Row> iterator() {
        if (!this.sorted) {
            this.doSort();
            this.sorted = true;
        }
        ArrayList<Row> list0 = this.list;
        this.list = new ArrayList();
        this.sorted = false;
        Iterator<Row> iter = list0.iterator();
        return iter;
    }

    public void doSort() {
        this.list.sort(this.comparator);
    }

    public int getRowCount() {
        return this.list.size();
    }

    public Store toStore(RowMeta rowMeta) {
        if (!this.sorted) {
            this.doSort();
        }
        return new ListStore(rowMeta, this.list);
    }

    public void reset() {
        this.list = new ArrayList();
        this.sorted = false;
    }
}

