/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import kd.bos.algo.dataset.store.spill.DummyInvokable;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;

public class MemIO {
    private static IOManager ioManager = new IOManagerAsync();
    private static final String KEY_MEMORY_SIZE = "algo.memory.operatorMaxSize";
    private static final int DEFAULT_MEMORY_SIZE = 0x1400000;
    private static final int PAGESIZE = 16384;
    private static final AbstractInvokable parentTask = new DummyInvokable();
    private MemoryManager memoryManager;

    public MemIO(int memorySize) {
        this.memoryManager = new MemoryManager((long)memorySize, 1, 16384, MemoryType.HEAP, false);
    }

    private static int getMemorySize() {
        String str = System.getProperty(KEY_MEMORY_SIZE);
        if (str != null) {
            try {
                return Integer.parseInt(str.trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0x1400000;
    }

    public IOManager getIoManager() {
        return ioManager;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public AbstractInvokable getParentTask() {
        return parentTask;
    }

    public void close() {
        this.memoryManager.shutdown();
    }
}

