/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.dataset.store.spill.LazyMemorySegmentSource;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.HeaderlessChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;

public class SpillingOutputView
extends AbstractPagedOutputView {
    private final ArrayList<MemorySegment> fullSegments = new ArrayList(16);
    private final MemorySegmentSource memorySource;
    private BlockChannelWriter<MemorySegment> writer;
    private final IOManager ioManager;
    private int blockCount;
    private int numBytesInLastSegment;
    private int numMemorySegmentsInWriter;

    public SpillingOutputView(IOManager ioManager, MemorySegmentSource memSource, int segmentSize) {
        super(memSource.nextSegment(), segmentSize, 0);
        this.memorySource = memSource;
        this.ioManager = ioManager;
    }

    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
        if (this.writer == null) {
            this.fullSegments.add(current);
            MemorySegment nextSeg = this.memorySource.nextSegment();
            if (nextSeg != null) {
                return nextSeg;
            }
            this.writer = this.ioManager.createBlockChannelWriter(this.ioManager.createChannel());
            this.numMemorySegmentsInWriter = this.blockCount = this.fullSegments.size();
            for (int i = 0; i < this.fullSegments.size(); ++i) {
                this.writer.writeBlock((Object)this.fullSegments.get(i));
            }
            this.fullSegments.clear();
            MemorySegment seg = (MemorySegment)this.writer.getNextReturnedBlock();
            --this.numMemorySegmentsInWriter;
            return seg;
        }
        this.writer.writeBlock((Object)current);
        ++this.blockCount;
        return (MemorySegment)this.writer.getNextReturnedBlock();
    }

    public DataInputView getViewNew(LazyMemorySegmentSource lazyMemorySegmentSource) throws IOException {
        if (this.writer == null) {
            return new RandomAccessInputView(this.fullSegments, this.segmentSize, this.numBytesInLastSegment);
        }
        BlockChannelReader reader = this.ioManager.createBlockChannelReader(this.writer.getChannelID());
        HeaderlessChannelReaderInputView externalInView = new HeaderlessChannelReaderInputView(reader, lazyMemorySegmentSource.getAllSegment(), this.blockCount, this.numBytesInLastSegment, false);
        return externalInView;
    }

    public DataInputView getView() throws IOException {
        if (this.getCurrentSegment() != null) {
            if (this.writer == null) {
                this.fullSegments.add(this.getCurrentSegment());
                this.numBytesInLastSegment = this.getCurrentPositionInSegment();
            } else {
                this.writer.writeBlock((Object)this.getCurrentSegment());
                ++this.numMemorySegmentsInWriter;
                this.numBytesInLastSegment = this.getCurrentPositionInSegment();
                ++this.blockCount;
                this.writer.close();
                for (int i = this.numMemorySegmentsInWriter; i > 0; --i) {
                    this.fullSegments.add((MemorySegment)this.writer.getNextReturnedBlock());
                }
                this.numMemorySegmentsInWriter = 0;
            }
            this.clear();
        }
        if (this.writer == null) {
            return new RandomAccessInputView(this.fullSegments, this.segmentSize, this.numBytesInLastSegment);
        }
        BlockChannelReader reader = this.ioManager.createBlockChannelReader(this.writer.getChannelID());
        HeaderlessChannelReaderInputView externalInView = new HeaderlessChannelReaderInputView(reader, this.fullSegments, this.blockCount, this.numBytesInLastSegment, false);
        return externalInView;
    }

    public List<MemorySegment> close() throws IOException {
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>(this.fullSegments.size() + this.numMemorySegmentsInWriter);
        if (this.getCurrentSegment() != null) {
            segments.add(this.getCurrentSegment());
            this.clear();
        }
        SpillingOutputView.moveAll(this.fullSegments, segments);
        this.fullSegments.clear();
        if (this.writer != null) {
            this.writer.close();
            for (int i = this.numMemorySegmentsInWriter; i > 0; --i) {
                segments.add((MemorySegment)this.writer.getNextReturnedBlock());
            }
            this.writer.closeAndDelete();
            this.writer = null;
        }
        return segments;
    }

    private static final <E> void moveAll(ArrayList<E> source, ArrayList<E> target) {
        target.ensureCapacity(target.size() + source.size());
        for (int i = source.size() - 1; i >= 0; --i) {
            target.add(source.remove(i));
        }
    }
}

